package tk.eclipse.plugin.visualjsf.models;

import java.lang.reflect.Method;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

/**
 * @author Naoki Takezoe
 */
public class ModelProperty {
	
	private Object model;
	private String setterMethod;
	private String getterMethod;
	private Class type;
	private IPropertyDescriptor descriptor;
	
	public ModelProperty(Object model, String propertyName, Class type, 
			IPropertyDescriptor descriptor){
		this(model, propertyName, type, descriptor, "General");
	}
	
	public ModelProperty(Object model, String propertyName, Class type, 
			IPropertyDescriptor descriptor, String category){
		this.model = model;
		this.setterMethod = HTMLUtil.getSetterName(propertyName);
		this.getterMethod = HTMLUtil.getGetterName(propertyName, false);
		this.type = type;
		this.descriptor = descriptor;
		((PropertyDescriptor)this.descriptor).setCategory(category);
	}
	
	public void setProperty(Object value){
		try {
			Method setter = getSetterMethod();
			setter.invoke(model, new Object[]{value});
		} catch(Exception ex){
			HTMLPlugin.logException(ex);
		}
	}
	
	public Object getProperty(){
		try {
			Method getter = getGetterMethod();
			return getter.invoke(model, new Object[0]);
		} catch(Exception ex){
			HTMLPlugin.logException(ex);
		}
		return null;
	}
	
	private Method getSetterMethod() throws Exception {
		Class clazz = this.model.getClass();
		Method setter = clazz.getMethod(setterMethod, new Class[]{type});
		return setter;
	}
	
	private Method getGetterMethod() throws Exception {
		Class clazz = this.model.getClass();
		Method getter = clazz.getMethod(getterMethod, new Class[]{});
		return getter;
	}
	
	public IPropertyDescriptor getDecriptor(){
		return this.descriptor;
	}
	
}
