package net.sf.amateras.air.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;

/**
 * Action that comments on ActionScrit source.
 * 
 * @author hideko ogawa
 */
public class CommentAction extends AbstractAirEditorAction {

	public void run(IAction action) {

		IDocument document = getTextEditor().getDocumentProvider().getDocument(getTextEditor().getEditorInput());
		ITextSelection txtSel = (ITextSelection) getTextEditor().getSelectionProvider().getSelection();

		int start = getStart(document, txtSel.getOffset());
		int len = getLength(document, start, txtSel.getLength() + (txtSel.getOffset() - start));

		try {
			String selectedText = document.get(start, len);
			List<String> ret = splitInLines(selectedText);

			//isAllComment?
			boolean isAllComment = true;
			for (String line : ret) {
				String v = line.replaceAll("\t", "");

				if (!(v.trim().startsWith("//"))) {
					isAllComment = false;
					break;
				}
			}

			int addTextSize = 0;
			StringBuilder strbuf = new StringBuilder(selectedText.length() + ret.size() + 2);
			for (String line : ret) {
				if (isAllComment) {
					strbuf.append(line.replaceFirst("//", ""));
					addTextSize = addTextSize - 2;
				} else {
					strbuf.append("//").append(line);
					addTextSize = addTextSize + 2;
				}
			}

			String replacement = strbuf.toString();
			document.replace(start, len, replacement);

			// set selection.
			int selectLength = txtSel.getLength() + addTextSize;
			if (selectLength > 0 && txtSel.getLength() != 0) {
				getTextEditor().getSelectionProvider()
						.setSelection(new TextSelection(txtSel.getOffset(), selectLength));
			}

		} catch (BadLocationException e) {
			throw new RuntimeException(e);
		}

	}

	/**
	 * get List to split lines.
	 * @param string
	 * @return
	 */
	public static List<String> splitInLines(String string) {
		ArrayList<String> ret = new ArrayList<String>();
		int len = string.length();
		if (len == 0) {
			ret.add("");
			return ret;
		}

		char c;
		StringBuilder buf = new StringBuilder();

		for (int i = 0; i < len; i++) {
			c = string.charAt(i);

			buf.append(c);

			if (c == '\r') {
				if (i < len - 1 && string.charAt(i + 1) == '\n') {
					i++;
					buf.append('\n');
				}
				ret.add(buf.toString());
				buf = new StringBuilder();
			}
			if (c == '\n') {
				ret.add(buf.toString());
				buf = new StringBuilder();

			}
		}
		if (buf.length() != 0) {
			ret.add(buf.toString());
		}
		return ret;

	}

	/**
	 * get replace target offset.
	 * @param document
	 * @param documentOffset
	 * @return
	 */
	private int getStart(IDocument document, int documentOffset) {
		if (documentOffset == 0) {
			return documentOffset;
		}
		while (true) {
			try {
				char c = document.getChar(--documentOffset);
				if (c == '\n' || c == '\r') {
					return documentOffset + 1;
				}

			} catch (BadLocationException e) {
				return documentOffset;
			}
		}
	}

	/**
	 * get replace target length.
	 * @param document
	 * @param start
	 * @param length
	 * @return
	 */
	private int getLength(IDocument document, int start, int length) {
		if (start + length == document.getLength()) {
			return length;
		}

		// when multi select text and first position, no select line.
		if (length > 0) {
			try {
				char c = document.getChar(start + length - 1);
				if (c == '\n' || c == '\r') {
					return length;
				}
			} catch (BadLocationException e) {
				return length;
			}
		}

		int documentOffset = start + length;
		int maxSize = document.getLength();
		if (start >= maxSize) {
			return 0;
		}
		while (true) {
			try {
				char c = document.getChar(documentOffset);
				if (!(c == '\t' || c == ' ' || c == '/')) {
					break;
				}
				documentOffset++;
				if (documentOffset >= maxSize) {
					break;
				}

			} catch (BadLocationException e) {
				return documentOffset;
			}
		}
		int newLength = documentOffset - start;
		return newLength;
	}
}
