package net.sf.amateras.air.debug.sourcelocater;

import java.io.File;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;

/**
 * 
 * @author hideko ogawa
 *
 */
public class AirSdkDirectorySourceContainer extends DirectorySourceContainer {

	public AirSdkDirectorySourceContainer(IPath path) {
		super(path, true);
	}

	@Override
	public Object[] findSourceElements(String name) throws CoreException {
		Object[] findSourceElements = super.findSourceElements(name);

		if (findSourceElements == EMPTY) {
			findSourceElements = searchMainObjet(new File(getDirectory(), "mx/controls/"), name);
		}

		if (findSourceElements == EMPTY) {
			findSourceElements = searchMainObjet(new File(getDirectory(), "mx/containers/"), name);
		}
		if (findSourceElements == EMPTY) {
			findSourceElements = searchMainObjet(new File(getDirectory(), "mx/core"), name);
		}
		if (findSourceElements == EMPTY) {
			findSourceElements = searchMainObjet(new File(getDirectory(), "mx/"), name);
		}

		return findSourceElements;
	}

	private Object[] searchMainObjet(File dir, String targetFileName) {
		if (dir.exists()) {
			File file = new File(dir, targetFileName);
			if (file.exists()) {
				return new Object[] { file.getAbsolutePath() };
			} else {
				String[] list = dir.list();
				for (String l : list) {
					File f = new File(dir, l);
					if (f.isDirectory()) {
						Object[] ret = searchMainObjet(f, targetFileName);
						if (ret != EMPTY) {
							return ret;
						}
					}
				}
			}
		}
		return EMPTY;
	}

}
