package net.sf.amateras.air.debug.sourcelocater;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

/**
 * StorageEditorInput for AIR GEAR.
 * @author hideko ogawa
 *
 */
public class AirStorageEditorInput implements IStorageEditorInput {
	private IStorage storage;

	public AirStorageEditorInput(IStorage storage) {
		this.storage = storage;
	}

	public IStorage getStorage() {
		return storage;
	}

	public String getName() {
		return this.storage.getName();
	}

	public IPersistableElement getPersistable() {
		return null;
	}

	public String getContentType() {
		return this.storage.getFullPath().getFileExtension();
	}

	public String getToolTipText() {
		IPath fullPath = storage.getFullPath();
		if (fullPath == null) {
			return null;
		}
		return fullPath.toString();
	}

	public Object getAdapter(@SuppressWarnings("unchecked")
	Class adapter) {
		return null;
	}

	public boolean exists() {
		return true;
	}

	public ImageDescriptor getImageDescriptor() {
		IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
		return registry.getImageDescriptor(getContentType());
	}

}
