package net.sf.amateras.air.debug.thread;

import net.sf.amateras.air.debug.AirDebugElement;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class AirVariable extends AirDebugElement implements IVariable {

	private String fName;

	//private AirStackFrame fFrame;

	public AirVariable(IDebugTarget target, String name) {
		super(target);
		fName = name;
	}

	public IValue getValue() {
		//String value = sendRequest("print " + getName(), DebugEvent.CONTENT);
		return new AirValue(this.getAirDebugTarget(), "");
	}

	public String getName() {
		return fName;
	}

	public String getReferenceTypeName() {
		return "Thing";
	}

	public boolean hasValueChanged() {
		return false;
	}

	public void setValue(String expression) {
		//sendRequest("set " + getName() + " = "+ expression, DebugEvent.CHANGE);
		fireChangeEvent(DebugEvent.CONTENT);
	}

	public void setValue(IValue value) {
	}

	public boolean supportsValueModification() {
		return true;
	}

	public boolean verifyValue(String expression) {
		return true;
	}

	public boolean verifyValue(IValue value) {
		return false;
	}

}
