package net.sf.amateras.air.debug.watch;

import net.sf.amateras.air.debug.AirDebugTarget;
import net.sf.amateras.air.debug.thread.AirStackFrame;
import net.sf.amateras.air.debug.thread.AirThread;

import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class AirWatchExpressionDelegate implements IWatchExpressionDelegate {

	public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {

		AirDebugTarget debugTarget = null;
		if (context instanceof AirThread) {
			debugTarget = ((AirThread) context).getAirDebugTarget();
		} else if (context instanceof AirDebugTarget) {
			debugTarget = (AirDebugTarget) context;
		} else if (context instanceof AirStackFrame) {
			debugTarget = ((AirStackFrame) context).getAirDebugTarget();
		}

		if (debugTarget != null) {
			IWatchExpressionResult expressionResult = debugTarget.getExpressionResult(expression);
			if (expressionResult != null) {
				listener.watchEvaluationFinished(expressionResult);
			}
		}

	}

}
