package net.sf.amateras.air.mxml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/**
 * 
 * @author Naoki Takezoe
 */
public class ElementWrapper {

	private Element element;
	private Set<String> fetchedAttrNames = new HashSet<String>();

	public ElementWrapper(Element element) {
		this.element = element;
	}

	public String getAttribute(String name) {
		fetchedAttrNames.add(name);
		return element.getAttribute(name);
	}

	public Map<String, Object> getAdditionalAttributes() {
		Map<String, Object> additionalAttributes = new HashMap<String, Object>();
		NamedNodeMap map = element.getAttributes();
		for (int i = 0; i < map.getLength(); i++) {
			Attr attr = (Attr) map.item(i);
			String name = attr.getName();
			if (!fetchedAttrNames.contains(name) && name.indexOf(":") < 0) {
				additionalAttributes.put(name, attr.getValue());
			}
		}
		return additionalAttributes;
	}

	public Element getElement() {
		return this.element;
	}
}
