package net.sf.amateras.air.mxml.action;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.editparts.ViewStackEditPart;
import net.sf.amateras.air.mxml.figures.ViewStackFigure;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.ViewStackModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

/**
 * Change ViewStack pane Action.
 * 
 * @author ogawahideko
 *
 */
public class ChangeStackAction extends MXMLEditorAction implements IMenuCreator, IStructuredSelectionRefresh {
	private ViewStackEditPart selectedStack;
	private Menu fMenu;
	private List<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
	private Menu parent;

	public ChangeStackAction(VisualMXMLEditor editor) {
		super("Change StackPage", editor);
		setMenuCreator(this);
	}

	public void setSelectedEditPart(ViewStackEditPart editPart) {
		this.selectedStack = editPart;
		if (selectedStack != null) {
			setMenu();
		}
	}

	@Override
	public void update(IStructuredSelection selection) {

	}

	public void dispose() {
		if (fMenu != null) {
			fMenu.dispose();
		}
		selectedStack = null;
		parent = null;
		items.clear();
	}

	public Menu getMenu(Control parent) {
		return null;
	}

	public Menu getMenu(Menu parent) {
		this.parent = parent;
		if (fMenu != null) {
			fMenu.dispose();
		}
		fMenu = new Menu(parent);
		setMenu();
		return fMenu;
	}

	@SuppressWarnings("unchecked")
	public Menu setMenu() {
		if (parent != null) {
			if (selectedStack == null) {
				return fMenu;
			}
			IFigure selectedFigure = ((ViewStackFigure) selectedStack.getFigure()).getSelectedFigure();
			List<IComponentModel> models = ((ViewStackModel) selectedStack.getModel()).getChildren();
			List<IFigure> figures = selectedStack.getFigure().getChildren();
			for (int i = 0; i < models.size(); i++) {
				IComponentModel child = models.get(i);
				boolean isSelected = false;
				IFigure myFigure = figures.get(i);
				if (selectedFigure == myFigure) {
					isSelected = true;
				}
				addActionToMenu(fMenu, child.toString(), isSelected, myFigure, i);
			}
			return fMenu;
		} else {
			return null;
		}

	}

	protected void addActionToMenu(Menu parent, String text, boolean isSelected, IFigure figure, int index) {
		if (items.size() > index) {
			ActionContributionItem item = items.get(index);
			((SelectedAction) item.getAction()).setText(text);
			((SelectedAction) item.getAction()).setIndex(index);
			((SelectedAction) item.getAction()).isSelected(isSelected);
			items.get(index).setVisible(true);
			item.fill(parent, -1);
		} else {
			SelectedAction action = new SelectedAction(text, isSelected, index);
			ActionContributionItem item = new ActionContributionItem(action);
			item.fill(parent, -1);
			items.add(item);

		}
	}

	protected void disableMenuItem(int startIndex) {
		for (int i = startIndex; i < items.size(); i++) {
			((SelectedAction) items.get(i).getAction()).setText("");
			((SelectedAction) items.get(i).getAction()).setIndex(i);
			((SelectedAction) items.get(i).getAction()).isSelected(false);
			items.get(i).setVisible(false);
		}
	}

	class SelectedAction extends Action {
		int index;

		SelectedAction(String title, boolean isSelected, int index) {
			super(title);
			isSelected(isSelected);
			setIndex(index);
		}

		public void isSelected(boolean isSelected) {
			setChecked(isSelected);
		}

		public void setIndex(int index) {
			this.index = index;
		}

		@Override
		public void run() {
			((ViewStackModel) selectedStack.getModel()).setSelectedIndex(index);
			for (ActionContributionItem item : items) {
				if (item.getAction() != this) {
					item.getAction().setChecked(false);
				}
			}
			super.run();
		}
	}

}
