package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.ComponentImageRegistry;
import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PropertyLabelDecoratorUtil extends LabelProvider {
	private String defaultValue;

	public PropertyLabelDecoratorUtil(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public PropertyLabelDecoratorUtil() {

	}

	@Override
	public Image getImage(Object element) {
		if (!(element.equals(AbstractModel.NULL_PROPERTY)) && element != getDefaultValue()) {
			return ComponentImageRegistry.getSetPropertyImage();
		} else {
			return null;
		}
	}

	@Override
	public String getText(Object element) {
		if (element == null || element == AbstractModel.NULL_PROPERTY) {
			if (getDefaultValue() == null) {
				return AbstractModel.NULL_PROPERTY;
			} else {
				return getDefaultValue();
			}
		} else {
			return getTextString(element);
		}
	}

	protected String getDefaultValue() {
		return defaultValue;
	}

	protected String getTextString(Object element) {
		return super.getText(element);
	}
}
