package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * PropertyDescriptor String.
 * @author ogawahideko
 *
 */
public class StringPropertyDescriptor extends TextPropertyDescriptor implements IEditorValueDescriptor<String> {

	private String defaultValue;

	public StringPropertyDescriptor(Object id, String displayName, String defaultValue) {
		super(id, displayName);
		if (defaultValue == null) {
			defaultValue = AbstractModel.NULL_PROPERTY;
		}
		this.defaultValue = defaultValue;
		setLabelProvider(new PropertyLabelDecoratorUtil(defaultValue));
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null && value.length() != 0) {
			return value;
		} else {
			return defaultValue;
		}
	}

}
