package net.sf.amateras.air.mxml.editparts;

import java.beans.PropertyChangeEvent;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.policy.EntityComponentEditPolicy;
import net.sf.amateras.air.mxml.figures.IFlexRectangleFigure;
import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.mxml.models.LabelModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IFileEditorInput;

/**
 * An abstract class for editparts which correspond to the GUI component model.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractComponentEditPart extends AbstractEditPart {

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new EntityComponentEditPolicy());
	}

	/**
	 * Returns the project which has the editing file.
	 * 
	 * @return the project
	 */
	protected IProject getProject() {
		DefaultEditDomain domain = (DefaultEditDomain) getViewer().getEditDomain();
		IFileEditorInput input = (IFileEditorInput) domain.getEditorPart().getEditorInput();
		return input.getFile().getProject();
	}

	/**
	 * Returns the embed resource as <code>IFile</code>.
	 * The given property must <code>@Embed('...')</code>.
	 * 
	 * @param property the attribute value
	 * @return the specified file or <code>null</code>
	 */
	protected IFile getEmbedResource(String property) {
		if (property.startsWith("@Embed(") && property.endsWith("')")) {
			property = property.replaceFirst("^@Embed\\(.*?'", "");
			property = property.replaceFirst("'\\)$", "");

			String filePath = null;

			DefaultEditDomain domain = (DefaultEditDomain) getViewer().getEditDomain();
			IFileEditorInput input = (IFileEditorInput) domain.getEditorPart().getEditorInput();

			IFile resource = input.getFile();
			if (resource != null) {
				String folder = resource.getProjectRelativePath().removeLastSegments(1).toString();
				filePath = folder + "/" + property;
			} else {
				filePath = property;
			}
			IFile file = getProject().getFile(new Path(filePath));
			if (file != null && file.exists()) {
				return file;
			}
		}
		return null;
	}

	protected Image getEmbedResourceAsImage(String property) {
		IFile file = getEmbedResource(property);
		if (file != null) {
			try {
				return new Image(null, file.getContents());
			} catch (CoreException ex) {
				AIRPlugin.logException(ex);
			}
		}
		return null;
	}

	@Override
	protected void refreshVisuals() {
		Object model = getModel();
		if (model instanceof IComponentModel) {
			IComponentModel compModel = (IComponentModel) model;

			String strX = compModel.getAttributeToString(IModel.X);
			String strY = compModel.getAttributeToString(IModel.Y);
			String strWidth = compModel.getAttributeToString(IModel.WIDTH);
			String strHeight = compModel.getAttributeToString(IModel.HEIGHT);

			FlexRectangle constraint = compModel.getConstraint();
			if (constraint == null) {
				constraint = new FlexRectangle();
			}
			constraint.setStrWidth(strWidth);
			constraint.setStrHeight(strHeight);
			constraint.setStrX(strX);
			constraint.setStrY(strY);

			//			constraint.width = constraint.getPrefferedWidth(getFigure());
			//			constraint.height = constraint.getPrefferedHeight(getFigure());
			refreshLayoutConstraint(constraint);
		}
	}

	protected void refreshLayoutConstraint(FlexRectangle constraint) {

		if (getFigure() instanceof IFlexRectangleFigure) {
			((IFlexRectangleFigure) getFigure()).setRectangle(constraint);
		} else {
			getFigure().setBounds(constraint);
		}

		if (getFigure().getParent() == null) {
			System.err.println("Figure parent is Null.figure=" + getFigure());
		} else {
			((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), constraint);

		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		refresh();
	}

	protected Color getColor(String propertyName) {
		return getColor((RGB) ((IModel) getModel()).getAttribute(propertyName));
	}

	protected Color getColor(RGB rgb) {
		return AIRPlugin.getDefault().getColorManager().getColor(rgb);
	}

	protected void setTextDecoration(AbstractComponentModel model, Label label) {
		Color color = getColor(LabelModel.COLOR);
		if (color != null) {
			label.setForegroundColor(getColor(LabelModel.COLOR));
		}
		Object align = model.getAttribute(LabelModel.TEXT_ALIGN);
		if (align != null) {
			if (align.toString().equals("right")) {
				label.setLabelAlignment(Label.RIGHT);
			} else if (align.toString().equals("center")) {
				label.setLabelAlignment(Label.CENTER);
			} else {
				label.setLabelAlignment(Label.LEFT);
			}
		}
	}

}
