package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.List;
import net.sf.amateras.air.mxml.models.ListModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link ListModel}.
 * 
 * @author ogawahideko
 */
public class ListEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		List list = new List();
		updateFigure(list, (ListModel) getModel());
		return list;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((List) getFigure(), (ListModel) getModel());
	}

	protected void updateFigure(List list, ListModel model) {
		list.setToolTip(new Label(model.toString()));
	}

}
