package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Color;

/**
 * 
 * @author Hideko Ogawa
 *
 */
public class DataGridColumnFigure extends AbstractFigure {
	private static final int DEFAULT_HEIGHT = 20;
	private static final int DEFAULT_WIDTH = 100;
	private Label title;

	public DataGridColumnFigure() {
		setLayoutManager(new BorderLayout());
		setPreferredSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

		title = new TitleLabel();
		add(title, BorderLayout.CENTER);
	}

	public void setText(String text) {
		title.setText(text);
	}

	public void setWidth(int width) {
		setPreferredSize(width, DEFAULT_HEIGHT);
	}

	public void setHeaderBackgroundColor(Color color) {
		if (color != null) {
			title.setBackgroundColor(color);
		}
	}

	public void setHeaderForegroundColor(Color color) {
		if (color != null) {
			title.setForegroundColor(color);
		}
	}

	public void setHeaderLabelAlignment(int align) {
		title.setLabelAlignment(align);
	}

	public Label getTitleFigure() {
		return title;
	}

	public int getDefaultHeight() {
		return 0;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

}
