package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.swt.graphics.Image;

/**
 * 
 * @author Hideko Ogawa
 */
public class RadioButtonFigure extends Button implements ColorConstants {
	static final Image CHECKED = AIRPlugin.getImageDescriptor("icons/radio.gif").createImage();

	public RadioButtonFigure() {
		super();
	}

	@Override
	protected void installDefaultStyle() {
		setIcon(CHECKED);
		setLabelAlignment(PositionConstants.LEFT);
		setIconTextGap(8);
	}

	@Override
	public void setIcon(Image image) {
		if (image != null) {
			super.setIcon(image);
		}
	}

}
