package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Label;

/**
 * 
 * @author ogawahideko
 *
 */
public class RichTextEditorFigure extends PanelFigure {
	private static final int DEFAULT_WIDTH = 325;
	private static final int DEFAULT_HEIGHT = 300;
	private static final int DEFAULT_BORDER_BOTTOM_WIDTH = 80;
	private TextArea textArea;

	public RichTextEditorFigure() {
		super();
		textArea = new TextArea();
		setLayoutManager(new BorderLayout());
		add(textArea, BorderLayout.CENTER);
		setBorderBottomWidth(DEFAULT_BORDER_BOTTOM_WIDTH);
	}

	public void setText(String s) {
		textArea.setText(s);
	}

	public Label getTextFigure() {
		return textArea.getTextFigure();
	}

	@Override
	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	@Override
	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

}
