package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.figures.layouts.ToolbarAbsoluteLayout;
import net.sf.amateras.air.mxml.figures.layouts.XYAbsoluteLayout;
import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class RootFigure extends Layer implements IFlexRectangleFigure {

	private ToolbarLayout toolBarLayout;
	private XYLayout xyLayout;
	private FlexRectangle rectangle;

	public RootFigure() {
		toolBarLayout = new ToolbarAbsoluteLayout();
		xyLayout = new XYAbsoluteLayout();
		setLayout(true);

	}

	public FlexRectangle getRectangle() {
		return rectangle;
	}

	public void setRectangle(FlexRectangle rectangle) {
		this.rectangle = rectangle;

	}

	public void setLayout(boolean isXyLayout) {
		if (isXyLayout && getLayoutManager() == xyLayout) {
			return;
		}
		if (isXyLayout) {
			setLayoutManager(xyLayout);
		} else {
			setLayoutManager(toolBarLayout);
		}
	}

	public ToolbarLayout getToolbarLayout() {
		return toolBarLayout;
	}

	public void setVertical(boolean isVertical) {
		toolBarLayout.setVertical(isVertical);
	}

	public void setSpacing(int spaceing) {
		toolBarLayout.setSpacing(spaceing);
	}

	@Override
	protected void paintFigure(Graphics graphics) {
		graphics.setForegroundColor(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		for (int x = 10; x < getSize().width; x = x + 10) {
			for (int y = 10; y < getSize().height; y = y + 10) {
				graphics.drawPoint(x, y);
			}
		}
	}

	public int getDefaultWidth() {
		return -1;
	}

	public int getDefaultHeight() {
		return -1;
	}

}
