package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.containers.Box.
 * 
 * @author hideko ogawa
 *
 */
public class BoxModel extends AbstractContainerModel {

	public static final String COMPONENT_NAME = "Box";

	public static final String DIRECTION = "direction";
	public static final String HORIZONTAL_ALIGN = "horizontalAlign";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_TOP = "paddingTop";
	public static final String VERTICAL_ALIGN = "verticalAlign";
	public static final String VERTICAL_GAP = "verticalGap";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addListModelProperty(DIRECTION, CATEGORY_PROPERTY, new String[] { "vertical", "horizontal" });
		addListModelProperty(HORIZONTAL_ALIGN, CATEGORY_STYLE, new String[] { "left", "center", "right" });
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "middle", "bottom" });
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
