package net.sf.amateras.air.mxml.models;

/**
 * model of mx.containers.ControlBar
 * @author ogawahideko
 *
 */
public class ControlBarModel extends BoxModel implements IDecidedParentComonent {
	private static final int DEFAULT_WIDTH = 50;
	private static final int DEFAULT_HEIGHT = 50;
	public static final String COMPONENT_NAME = "ControlBar";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addListModelProperty(DIRECTION, CATEGORY_PROPERTY, new String[] { "horizontal", "vertical" });
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 10);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 10);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 10);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 10);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

}
