package net.sf.amateras.air.mxml.models;

import java.util.List;
import java.util.Map;

import org.w3c.dom.Element;

public interface IModel {
	String CATEGORY_PROPERTY = "Properties";
	String CATEGORY_STYLE = "Styles";
	String CATEGORY_EVENT = "Events";
	String CATEGORY_EFFECT = "Effects";
	String CATEGORY_LAYOUT = "Layout";

	String CATEGORY_COMMON_PROPERTY = "Properties";
	String CATEGORY_COMMON_EVENT = "Events";
	String CATEGORY_COMMON_STYLE = "Styles";

	String ID = "id";
	String X = "x";
	String Y = "y";
	String WIDTH = "width";
	String HEIGHT = "height";

	void setAttribute(String propertyName, Object value);

	Object getAttribute(String propertyName);

	String getAttributeToString(String propertyName);

	void addAdditionalChildElement(Element childNode);

	List<Element> getAdditionalChildElements();

	void setAdditionalAttributes(Map<String, Object> additionalAttributes);

	Map<String, Object> getAdditionalAttributes();

	Map<Object, ModelProperty> getModelProperties();

	// void resetPropertyValue(String id);

	void setPropertyValue(Object id, Object value);

}
