package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.LinkButton
 * 
 * @author ogawahideko
 * 
 */
public class LinkButtonModel extends ButtonModel {
	public static final String COMPONENT_NAME = "LinkButton";

	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String ROLL_OVER_COLOR = "rollOverColor";
	public static final String SELECTION_COLOR = "selectionColor";
	public static final String TEXT_ROLL_OVER_COLOR = "textRollOverColor";
	public static final String TEXT_SELECTED_COLOR = "textSelectedColor";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(CORNER_RADIUS, CATEGORY_STYLE);
		addColorModelProperty(ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#EEFEE6"));
		addColorModelProperty(SELECTION_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#B7F39B"));
		addColorModelProperty(TEXT_ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));
		addColorModelProperty(TEXT_SELECTED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
