package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.containers.VDividedBox
 * @author ogawahideko
 *
 */
public class VDividedBoxModel extends DividedBoxModel {
	private static final int DEFAULT_WIDTH = 50;
	private static final int DEFAULT_HEIGHT = 50;
	private static final String COMPONENT_NAME = "VDividedBox";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addListModelProperty(DIRECTION, CATEGORY_PROPERTY, new String[] { "vertical" });
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

}
