package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * 
 * @author Naoki Takezoe
 */
public class AIRPreferencePage extends PreferencePage implements IWorkbenchPreferencePage {

	private Text airSdkPath;
	private Text flexSdkPath;
	private Text fcshPath;
	private Text adlPath;
	private Text adtPath;
	private Text fdbPath;

	public AIRPreferencePage() {
		super("AIR GEAR");
		setPreferenceStore(AIRPlugin.getDefault().getPreferenceStore());
	}

	@Override
	protected Control createContents(Composite parent) {
		IPreferenceStore stote = getPreferenceStore();

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		airSdkPath = addButtonPath(composite, "AIR SDK:");
		airSdkPath.setText(stote.getString(AIRPlugin.PREF_AIR_SDK_PATH));

		flexSdkPath = addButtonPath(composite, "Flex SDK:");
		flexSdkPath.setText(stote.getString(AIRPlugin.PREF_FLEX_SDK_PATH));

		Group groupPath = new Group(parent, SWT.NULL);
		groupPath.setLayout(new GridLayout(2, false));
		groupPath.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		adlPath = addRelatedPath(groupPath, "ADL:", "Flex SDK/");
		adlPath.setText(stote.getString(AIRPlugin.PREF_ADL_COMMAND));
		adtPath = addRelatedPath(groupPath, "ADT:", "Flex SDK/");
		adtPath.setText(stote.getString(AIRPlugin.PREF_ADT_COMMAND));
		fcshPath = addRelatedPath(groupPath, "FCSH:", "Flex SDK/");
		fcshPath.setText(stote.getString(AIRPlugin.PREF_FCSH_SHELL_COMMAND));
		fdbPath = addRelatedPath(groupPath, "FDB:", "Flex SDK/");
		fdbPath.setText(stote.getString(AIRPlugin.PREF_FDB_COMMAND));

		return composite;
	}

	private Text addButtonPath(Composite parent, String label) {
		UIUtil.createLabel(label, parent);
		Composite composite2 = new Composite(parent, SWT.NULL);
		composite2.setLayout(new GridLayout(2, false));
		composite2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		final Text text = new Text(composite2, SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Button browse = new Button(composite2, SWT.PUSH);
		browse.setText("Browse...");
		browse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog dialog = new DirectoryDialog(getShell());
				String result = dialog.open();
				if (result != null) {
					text.setText(result);
				}
			}
		});
		return text;
	}

	private Text addRelatedPath(Composite parent, String label, String parentLabel) {
		UIUtil.createLabel(label, parent);
		Composite composite2 = new Composite(parent, SWT.NULL);
		composite2.setLayout(new GridLayout(2, false));
		composite2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		UIUtil.createLabel(parentLabel, composite2);
		Text text = new Text(composite2, SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return text;
	}

	public void init(IWorkbench workbench) {
		// Nothing to do.
	}

	@Override
	protected void performDefaults() {
		IPreferenceStore stote = getPreferenceStore();
		airSdkPath.setText(stote.getDefaultString(AIRPlugin.PREF_AIR_SDK_PATH));
		flexSdkPath.setText(stote.getDefaultString(AIRPlugin.PREF_FLEX_SDK_PATH));
		fcshPath.setText(stote.getDefaultString(AIRPlugin.PREF_FCSH_SHELL_COMMAND));
		adlPath.setText(stote.getDefaultString(AIRPlugin.PREF_ADL_COMMAND));
		adtPath.setText(stote.getDefaultString(AIRPlugin.PREF_ADT_COMMAND));
		fdbPath.setText(stote.getDefaultString(AIRPlugin.PREF_FDB_COMMAND));
		super.performDefaults();
	}

	@Override
	public boolean performOk() {
		IPreferenceStore stote = getPreferenceStore();
		stote.setValue(AIRPlugin.PREF_AIR_SDK_PATH, airSdkPath.getText());
		stote.setValue(AIRPlugin.PREF_FLEX_SDK_PATH, flexSdkPath.getText());
		stote.setValue(AIRPlugin.PREF_FCSH_SHELL_COMMAND, fcshPath.getText());
		stote.setValue(AIRPlugin.PREF_ADL_COMMAND, adlPath.getText());
		stote.setValue(AIRPlugin.PREF_ADT_COMMAND, adtPath.getText());
		stote.setValue(AIRPlugin.PREF_FDB_COMMAND, fdbPath.getText());
		return true;
	}

}
