package net.sf.amateras.air.propertyPages;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.builder.AirBuilderManager;
import net.sf.amateras.air.util.AIRResources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * 
 * @author Naoki Takezoe
 */
public class BuildPathPropertyPage extends PropertyPage implements IWorkbenchPropertyPage {

	private TableViewer viewer;
	private List<Object> libs = null;

	private IProject getProject() {
		IAdaptable adaptable = getElement();
		if (adaptable instanceof IProject) {
			return (IProject) adaptable;
		}
		return (IProject) adaptable.getAdapter(IProject.class);
	}

	@Override
	protected Control createContents(Composite parent) {
		ScopedPreferenceStore store = new ScopedPreferenceStore(new ProjectScope(getProject()), AIRPlugin.PLUGIN_ID);
		setPreferenceStore(store);
		libs = loadLibraries();

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		viewer = new TableViewer(composite);
		viewer.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setLabelProvider(new ITableLabelProvider() {
			public Image getColumnImage(Object element, int column) {
				return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.SWC_JAR);
			}

			public String getColumnText(Object element, int column) {
				if (element instanceof IFile) {
					return ((IFile) element).getProjectRelativePath().toString();
				} else if (element instanceof File) {
					return ((File) element).getAbsolutePath();
				}
				return null;
			}

			public void addListener(ILabelProviderListener listener) {
			}

			public void dispose() {
			}

			public boolean isLabelProperty(Object element, String property) {
				return false;
			}

			public void removeListener(ILabelProviderListener listener) {
			}
		});
		try {
			viewer.setInput(libs);
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		Composite buttons = new Composite(composite, SWT.NULL);
		buttons.setLayout(new GridLayout(1, false));
		buttons.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

		Button addWorkspaceButton = createButton("Add Library", buttons);
		addWorkspaceButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent evt) {
				ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(getShell(),
						new WorkbenchLabelProvider(), new WorkbenchContentProvider() {
							@Override
							public Object[] getChildren(Object element) {
								List<Object> result = new ArrayList<Object>();
								Object[] children = super.getChildren(element);
								for (int i = 0; i < children.length; i++) {
									if (children[i] instanceof IFile
											&& !((IFile) children[i]).getName().endsWith(".swc")) {
										continue;
									}
									result.add(children[i]);
								}
								return result.toArray();
							}
						});

				dialog.setTitle("Add Library");
				dialog.setInput(getProject());
				dialog.setValidator(new ISelectionStatusValidator() {
					private IStatus okStatus = new Status(Status.OK, AIRPlugin.PLUGIN_ID, Status.OK, "", null);
					private IStatus ngStatus = new Status(Status.ERROR, AIRPlugin.PLUGIN_ID, Status.ERROR, "", null);

					public IStatus validate(Object[] selection) {
						for (int i = 0; i < selection.length; i++) {
							if (!(selection[i] instanceof IFile)) {
								return ngStatus;
							}
							if (!((IFile) selection[i]).getName().endsWith(".swc")) {
								return ngStatus;
							}
							if (libs.contains(selection[i])) {
								return ngStatus;
							}
						}
						if (selection.length == 0) {
							return ngStatus;
						}
						return okStatus;
					}
				});
				if (dialog.open() == Dialog.OK) {
					Object[] results = dialog.getResult();
					for (int i = 0; i < results.length; i++) {
						libs.add(results[i]);
					}
					viewer.refresh();
				}
			}
		});

		//		Button addFilesystemButton = createButton("Add External Library", buttons);
		//		addFilesystemButton.addSelectionListener(new SelectionAdapter(){
		//			public void widgetSelected(SelectionEvent e) {
		//				FileDialog dialog = new FileDialog(getShell(), SWT.OPEN);
		//				dialog.setFilterExtensions(new String[]{"*.swc"});
		//				String result = dialog.open();
		//				if(result != null){
		//					libs.add(new File(result));
		//					viewer.refresh();
		//				}
		//			}
		//		});

		Button removeButton = createButton("Remove", buttons);
		removeButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection sel = (IStructuredSelection) viewer.getSelection();
				libs.removeAll(sel.toList());
				viewer.refresh();
			}
		});

		return composite;
	}

	@Override
	protected void performDefaults() {
		this.libs.clear();
		this.viewer.refresh();
	}

	private List<Object> loadLibraries() {
		IPreferenceStore store = getPreferenceStore();
		String libraries = store.getString(AIRPlugin.PREF_FLEX_LIBRARIES);
		List<Object> result = new ArrayList<Object>();
		String[] dim = libraries.split("\t");
		IProject project = getProject();
		for (int i = 0; i < dim.length; i++) {
			try {
				if (dim[i].length() != 0) {
					IFile file = (IFile) project.findMember(new Path(dim[i]));
					if (file != null) {
						result.add(file);
					} else {
						result.add(dim[i]);
					}
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
		return result;
	}

	@Override
	public boolean performOk() {
		IPreferenceStore store = getPreferenceStore();
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < this.libs.size(); i++) {
			IFile file = (IFile) this.libs.get(i);
			String path = file.getProjectRelativePath().removeFirstSegments(0).toString();
			sb.append(path).append("\t");
		}
		store.setValue(AIRPlugin.PREF_FLEX_LIBRARIES, sb.toString().trim());
		AirBuilderManager.doClean(getProject());
		return true;
	}

	private Button createButton(String text, Composite parent) {
		Button button = new Button(parent, SWT.PUSH);
		button.setText(text);
		button.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return button;
	}

}
