package net.sf.amateras.air.templates;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.AIRResources;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;

/**
 * TemplateCompletionProcessor for ActionScript3 Editor.
 * 
 * @author ogawahideko
 *
 */
public class ActionScriptTemplateCompletionProcessor extends TemplateCompletionProcessor {

	private Image tmplImage;

	public ActionScriptTemplateCompletionProcessor() {
		super();
		ImageRegistry registry = AIRPlugin.getDefault().getImageRegistry();
		tmplImage = registry.get(AIRResources.CONTENTS_ASSIST_TEMPLATE);
	}

	@Override
	protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
		TemplateContextType contextType = getContextType(viewer, region);
		if (contextType != null) {
			IDocument document = viewer.getDocument();
			return new ActionScriptTemplateContext(contextType, document, region.getOffset(), region.getLength());
		}
		return null;
	}

	@Override
	protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
		return AIRPlugin.getDefault().getCotextAS3TypeRegistry().getContextType(AIRPlugin.CONTEXT_AS3_TYPE_ID);
	}

	@Override
	protected Image getImage(Template template) {
		return tmplImage;
	}

	@Override
	protected Template[] getTemplates(String contextTypeId) {
		return AIRPlugin.getDefault().getTemplateAS3Store().getTemplates();
	}

	@Override
	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
		ICompletionProposal[] proposals = super.computeCompletionProposals(viewer, offset);
		String prefix = extractPrefix(viewer, offset);
		List<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
		for (ICompletionProposal p : proposals) {
			if (p.getDisplayString().startsWith(prefix)) {
				matches.add(p);
			}
		}
		return matches.toArray(new ICompletionProposal[matches.size()]);
	}

}
