package net.sf.amateras.air.wizards;

import java.util.Map;

import net.sf.amateras.air.natures.AIRFlexProjectNature;
import net.sf.amateras.air.templates.DescriptorContextType;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * 
 * @author Naoki Takezoe
 */
public class NewAIRFlexProjectWizard extends AbstractNewAIRProjectWizard {

	public NewAIRFlexProjectWizard() {
		setWindowTitle("New AIR Flex Project");
	}

	@Override
	protected void addProjectSpecificParameters(Map<String, String> params) {
		String mainSWF = ((AIRFlexProjectPropertiesWizardPage) page2).getMainSWF();
		params.put(DescriptorContextType.CONTENT, mainSWF);
		params.put("content-as", mainSWF.replaceFirst("\\.swf$", ".as"));
	}

	@Override
	protected AIRProjectWizardPage createPage1() {
		AIRProjectWizardPage page = new AIRProjectWizardPage("New Flex AIR Application Project",
				AIRProjectWizardPage.FLEX_PROJECT);
		page.setTitle("New Flex AIR Application Project");
		page.setDescription("Create new Flex based AIR application project.");
		return page;
	}

	@Override
	protected AbstractAIRProjectPropertiesWizardPage createPage2() {
		AIRFlexProjectPropertiesWizardPage page = new AIRFlexProjectPropertiesWizardPage("Flex Project Properties");
		page.setTitle("Flex Project Properties");
		page.setDescription("Input your project properties.");
		return page;
	}

	@Override
	protected void createProjectSpecificResources(IProject project, String descriptorTemplateName,
			Map<String, String> params, IProgressMonitor monitor) throws Exception {
		// make required files
		createFile(project, "application.xml", getTemplateContents(descriptorTemplateName), params, monitor);

		// make main mxml
		createFile(project, (params.get("content")).replaceFirst("\\.swf$", ".mxml"), NewAIRFlexProjectWizard.class
				.getResourceAsStream("main.mxml"), params, monitor);

		createFile(project, params.get("content-as"), NewAIRFlexProjectWizard.class.getResourceAsStream("main.as"),
				params, monitor);
	}

	@Override
	protected String getNatureId() {
		return AIRFlexProjectNature.NATURE_ID;
	}

}
