package net.sf.amateras.air.wizards.file;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.templates.ActionScriptTemplateContext;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;

/**
 * wizard for MXML file create.
 * @author ogawahideko
 *
 */
public class WizardNewASFileCreation extends AbstractFileWizard {

	@Override
	public AbstractFileCreationPage createPage(ISelection selection) {
		return new WizardNewASFileCreationPage(selection);
	}

	@Override
	public InputStream openContentStream(String fileName, String packageName, String templateName,
			Map<String, String> params) {
		String contents = "";
		AIRPlugin plugin = AIRPlugin.getDefault();
		TemplateStore templateStore = plugin.getTemplateAS3Store();
		TemplateContextType contextType = plugin.getCotextAS3TypeRegistry().getContextType(
				AIRPlugin.CONTEXT_AS3_TYPE_ID);
		ActionScriptTemplateContext context = new ActionScriptTemplateContext(contextType, new Document(" "), 0, 0);

		try {
			StringBuffer buf = new StringBuffer("");
			if (!templateName.equals("Simple")) {
				String pattern;

				Template t1 = templateStore.findTemplateById("net.sf.amateras.air.templates.new" + templateName);
				buf.append("public ");
				pattern = t1.getPattern();

				StringTokenizer tokenizer = new StringTokenizer(pattern, "\r\n", false);
				if (tokenizer.hasMoreElements()) {
					buf.append(tokenizer.nextToken() + "\n");
				}
				while (tokenizer.hasMoreTokens()) {
					buf.append("\t" + tokenizer.nextToken() + "\n");
				}
			}
			Template t = templateStore.findTemplateById("net.sf.amateras.air.templates.newPackage");
			Template template = new Template(t.getName(), t.getDescription(), t.getContextTypeId(), t.getPattern()
					.replace("${cursor}", buf.toString()).replace("${package_name}", packageName).replace(
							"${type_name}", fileName), false);
			TemplateBuffer templateBuffer = context.evaluate(template);
			contents = templateBuffer.getString();
		} catch (Exception e1) {
			contents = "package " + packageName + "{\n\t// template error \n}";
			e1.printStackTrace();
		}
		return new ByteArrayInputStream(contents.getBytes());
	}

	@Override
	protected void doOther(IContainer container, IPath path, Map<String, String> params, IProgressMonitor moniter) {
		// 
	}
}
