package net.sf.amateras.air;

import java.util.HashMap;
import java.util.Map;

import net.sf.amateras.air.mxml.MXMLLoader;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.RootModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class MxmlAsMap {
	private static MxmlAsMap instance;
	private Map<IFile, IFile> mxmlMap;

	private MxmlAsMap() {
		mxmlMap = new HashMap<IFile, IFile>();
	}

	public static MxmlAsMap getInstance() {
		if (instance == null) {
			instance = new MxmlAsMap();
		}
		return instance;
	}

	public IFile getMxmlFile(IFile asFile) {
		IFile mxmlFile = getMxmlFileSub(asFile);
		if (mxmlFile == null) {
			addMxmlAsMapProject(asFile.getProject());
			mxmlFile = getMxmlFileSub(asFile);
		}
		return mxmlFile;
	}

	private IFile getMxmlFileSub(IFile asFile) {
		for (IFile file : mxmlMap.keySet()) {
			if (mxmlMap.get(file).getFullPath().toOSString().equals(asFile.getFullPath().toOSString())) {
				return file;
			}
		}
		return null;
	}

	private void addMxmlAsMapProject(IProject project) {
		try {
			project.accept(new IResourceVisitor() {
				public boolean visit(IResource resource) throws CoreException {
					if (resource instanceof IFile && ((IFile) resource).getFileExtension().equals("mxml")) {
						IFile mxmlFile = (IFile) resource;
						RootModel root = new RootModel();
						MXMLLoader.loadMXML(mxmlFile.getContents(), root);
						addMxml(mxmlFile, root);
					}
					return true;
				}
			}, IResource.DEPTH_INFINITE, IResource.NONE);
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void addMxml(IFile mxmlFile, RootModel root) {
		String script = null;
		if (root.getChildren().size() > 0 && root.getChildren().get(0) instanceof AbstractContainerModel) {
			script = ((AbstractContainerModel) root.getChildren().get(0)).getScript();
		}
		if (script != null) {
			IResource findMember = mxmlFile.getParent().findMember(script);
			if (findMember != null && findMember.exists() && findMember instanceof IFile) {
				MxmlAsMap.getInstance().addMxmlAsMap(mxmlFile, (IFile) findMember);
			} else {
				MxmlAsMap.getInstance().removeMxmlAsMap(mxmlFile);
			}
		} else {
			MxmlAsMap.getInstance().removeMxmlAsMap(mxmlFile);
		}
	}

	public void addMxmlAsMap(IFile mxmlFile, IFile asFile) {
		mxmlMap.put(mxmlFile, asFile);
	}

	public void removeMxmlAsMap(IFile mxmlFile) {
		mxmlMap.remove(mxmlFile);
	}
}
