package net.sf.amateras.air.actions;

import net.sf.amateras.air.debug.sourcelocater.AirSdkDirectorySourceContainer;
import net.sf.amateras.air.debug.sourcelocater.AirSourceLookupDirector;

import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenDeclarationAction extends AbstractAirEditorAction {

	public void run(IAction action) {
		Object sourcePath = getSelectionString();
		if (sourcePath == null) {
			return;
		}
		AirSourceLookupDirector airSourceLookupDirector = new AirSourceLookupDirector();
		airSourceLookupDirector.initializeParticipants();
		airSourceLookupDirector.setSourceContainers(new ISourceContainer[] { new AirSdkDirectorySourceContainer(
				new org.eclipse.core.runtime.Path("")) });

		ISourceLookupResult lookupSource = DebugUITools.lookupSource(sourcePath, airSourceLookupDirector);
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();

		DebugUITools.displaySource(lookupSource, page);
	}

	private String getSelectionString() {
		if (selection instanceof TextSelection) {
			return ((TextSelection) selection).getText();
		}

		return null;
	}

}
