package net.sf.amateras.air.as;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

import jp.sourceforge.asclipse.as3.adapter.OutlineProvider;
import jp.sourceforge.asclipse.as3.element.AS3Element;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.as.outline.ActionScriptOutlinePage;
import net.sf.amateras.air.util.AS3ElementsUtil;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/**
 * Text Editor for Action Script.
 * @author Naoki Takezoe
 */
public class ActionScriptEditor extends TextEditor {

	private IDocumentPartitioner partitioner = new FastPartitioner(new ActionScriptPartitionScanner(), new String[] {
			ActionScriptPartitionScanner.AS_COMMENT, ActionScriptPartitionScanner.AS_STRING });

	private ActionScriptOutlinePage outlinePage;

	private AS3Element as3Element;

	public ActionScriptEditor() {
		setSourceViewerConfiguration(new ActionScriptConfiguration(this));
	}

	@Override
	protected void doSetInput(IEditorInput input) throws CoreException {
		super.doSetInput(input);

		IDocument document = getDocumentProvider().getDocument(input);
		if (document.getDocumentPartitioner() == null) {
			partitioner.connect(document);
			document.setDocumentPartitioner(partitioner);
		}

		createAS3Element(input);

		if (outlinePage != null) {
			outlinePage.setAS3Element(as3Element);
			outlinePage.setInput(input);
		}
	}

	private void createAS3Element(IEditorInput editorInput) {
		if (!AIRPlugin.getDefault().getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_PARSE_ENABLED)) {
			as3Element = null;
			return;
		}
		if (editorInput instanceof IFileEditorInput) {
			String fileName = ((IFileEditorInput) editorInput).getFile().getFullPath().toPortableString();
			byte[] bytes = getDocumentProvider().getDocument(editorInput).get().getBytes();
			InputStream is = new ByteArrayInputStream(bytes);
			as3Element = AS3ElementsUtil.addAS3Element(fileName, is);
		} else {
			as3Element = null;
		}
	}

	@Override
	protected void createActions() {
		super.createActions();
		IAction action = new ContentAssistAction(AIRPlugin.getResourceBundle(), "ContentAssistProposal", this);
		action.setActionDefinitionId(ITextEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS);
		setAction("ContentAssistProposal", action);
	}

	@Override
	protected void initializeKeyBindingScopes() {
		super.initializeKeyBindingScopes();
		setKeyBindingScopes(new String[] { "net.sf.amateras.air.editor.textEditorScope" });

	}

	@Override
	protected void initializeEditor() {
		super.initializeEditor();
		setEditorContextMenuId("#ActionScriptEditorContext");
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class clazz) {
		if (IContentOutlinePage.class.equals(clazz)) {
			if (!AIRPlugin.getDefault().getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED)) {
				return super.getAdapter(clazz);
			}
			if (this.outlinePage == null) {

				this.outlinePage = new ActionScriptOutlinePage(getDocumentProvider(), this, getAS3Element());
				if (getEditorInput() != null) {
					outlinePage.setAS3Element(as3Element);
					outlinePage.setInput(getEditorInput());
				}
			}
			return outlinePage;
		}

		return super.getAdapter(clazz);
	}

	public AS3Element getAS3Element() {
		return as3Element;
	}

	public List<AS3Element> getAS3ChildElements() {
		if (as3Element == null) {
			return null;
		}
		OutlineProvider adapter = as3Element.getAdapter(OutlineProvider.class);
		if (adapter == null) {
			return null;
		}
		return adapter.getOutlineChildren();
	}

	//	public ActionScriptContentProvider getAS3ContentProvider() {
	//		if (this.outlinePage == null) {
	//			getAdapter(IContentOutlinePage.class);
	//		}
	//		IDocument document = getDocumentProvider().getDocument(getEditorInput());
	//		return outlinePage.getAS3ContentProvider(document);
	//	}

	@Override
	protected void editorSaved() {
		super.editorSaved();
		createAS3Element(getEditorInput());
		if (outlinePage != null) {
			outlinePage.setAS3Element(as3Element);
			outlinePage.update();
		}
	}
}
