package net.sf.amateras.air.as;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.as.syntax.analyze.ReservedWordsAnalizer;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class ActionScriptKeywordPartitionScanner extends RuleBasedScanner {
	public ActionScriptKeywordPartitionScanner() {
		IToken keyword = AIRPlugin.getDefault().getEditorColorProvider().getToken(AIRPlugin.PREF_COLOR_KEYWORD);
		IToken other = AIRPlugin.getDefault().getEditorColorProvider().getToken(AIRPlugin.PREF_COLOR_DEFAULT);

		WordRule wordRule = new WordRule(new IWordDetector() {
			public boolean isWordPart(char c) {
				return Character.isJavaIdentifierPart(c);
			}

			public boolean isWordStart(char c) {
				return Character.isJavaIdentifierStart(c);
			}
		}, other);

		String[] keyWords = new ReservedWordsAnalizer().getReservedWords();

		for (int i = 0; i < keyWords.length; i++) {
			wordRule.addWord(keyWords[i], keyword);
		}
		IRule[] rules = new IRule[2];
		rules[0] = wordRule;
		rules[1] = new WhitespaceRule(new IWhitespaceDetector() {
			public boolean isWhitespace(char character) {
				return Character.isWhitespace(character);
			}
		});

		setRules(rules);
	}

}
