package net.sf.amateras.air.as;

import net.sf.amateras.air.as.syntax.SyntaxContextInformationValidator;
import net.sf.amateras.air.as.syntax.SyntaxReader;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

/**
 * 
 * @author ogawahideko
 *
 */
public class DefaultContentAssistProcessor implements IContentAssistProcessor {
	private ActionScriptEditor fEditor;

	public DefaultContentAssistProcessor(ActionScriptEditor editor) {
		this.fEditor = editor;
	}

	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
		try {
			return SyntaxReader.getInstance().computeCompletionProposals(viewer, documentOffset, fEditor);
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException(ex);
		}
	}

	public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
		return null;
	}

	public char[] getCompletionProposalAutoActivationCharacters() {
		return new char[] { '.', '(' };
	}

	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}

	public String getErrorMessage() {
		return null;
	}

	public IContextInformationValidator getContextInformationValidator() {
		return new SyntaxContextInformationValidator();
	}
}
