package net.sf.amateras.air.as.outline;

import jp.sourceforge.asclipse.as3.adapter.OutlineProvider;
import jp.sourceforge.asclipse.as3.element.AS3Element;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ActionScriptContentProvider implements ITreeContentProvider {

	private static final Object[] EMPTY_OBJECTS = new Object[0];

	protected static final String SEGMENTS = "__as3_segments"; //$NON-NLS-1$

	protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater(SEGMENTS);

	//protected ActionScriptEditor fEditor;

	protected IDocumentProvider fDocumentProvider;

	protected AS3Element fAS3Element;

	//	private OutlineProvider outlineProvider;

	public ActionScriptContentProvider(IDocumentProvider documentProvider) {
		this.fDocumentProvider = documentProvider;
	}

	public void setAS3Element(AS3Element as3Element) {
		this.fAS3Element = as3Element;
		if (as3Element == null) {
			return;
		}
		OutlineProvider adapter = as3Element.getAdapter(OutlineProvider.class);
		if (adapter == null) {
			as3Element.addAdapter(new OutlineProvider(null));
		}
	}

	//	public AS3Element getAS3Element() {
	//		return as3Element;
	//	}

	//	public void parse(IDocument document) {
	//		InputStream is = new ByteArrayInputStream(document.get().getBytes());
	//		try {
	//			as3Element = ParserUtil.parse(is);
	//			outlineProvider = as3Element.getAdapter(OutlineProvider.class);
	//			if (outlineProvider == null) {
	//				as3Element.addAdapter(new OutlineProvider(null));
	//			}
	//		} catch (AS3ParserException ex) {
	//			as3Element = null;
	//			//AIRPlugin.logException(ex);
	//		}
	//	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (oldInput != null) {
			IDocument document = fDocumentProvider.getDocument(oldInput);
			if (document != null) {
				try {
					document.removePositionCategory(SEGMENTS);
				} catch (BadPositionCategoryException x) {
					//nothing todo.
				}
				document.removePositionUpdater(fPositionUpdater);
			}
		}

		if (newInput != null) {
			IDocument document = fDocumentProvider.getDocument(newInput);
			if (document != null) {
				document.addPositionCategory(SEGMENTS);
				document.addPositionUpdater(fPositionUpdater);

				OutlineProvider outlineProvider = fAS3Element.getAdapter(OutlineProvider.class);
				if (outlineProvider == null) {
					fAS3Element.addAdapter(new OutlineProvider(null));
				}
			}
		}
	}

	public void dispose() {
		fAS3Element = null;
	}

	public Object[] getElements(Object element) {
		return getChildren(fAS3Element);
	}

	public boolean hasChildren(Object element) {
		if (element instanceof AS3Element && ((AS3Element) element).hasAdapter(OutlineProvider.class)) {
			OutlineProvider adapter = ((AS3Element) element).getAdapter(OutlineProvider.class);
			return !adapter.isLeaf() && !adapter.getOutlineChildren().isEmpty();
		} else {
			return false;
		}
	}

	public Object getParent(Object element) {
		if (!(element instanceof AS3Element)) {
			return null;
		}
		OutlineProvider adapter = ((AS3Element) element).getAdapter(OutlineProvider.class);
		if (adapter == null) {
			return null;
		}
		return adapter.getOutlineParent();
	}

	public Object[] getChildren(Object element) {
		if (!(element instanceof AS3Element)) {
			return EMPTY_OBJECTS;
		}
		OutlineProvider adapter = ((AS3Element) element).getAdapter(OutlineProvider.class);
		if (adapter == null) {
			return EMPTY_OBJECTS;
		}
		return adapter.getOutlineChildren().toArray();
	}
}
