package net.sf.amateras.air.as.outline;

import jp.sourceforge.asclipse.as3.element.AS3Class;
import jp.sourceforge.asclipse.as3.element.AS3ConstProperty;
import jp.sourceforge.asclipse.as3.element.AS3Element;
import jp.sourceforge.asclipse.as3.element.AS3Function;
import jp.sourceforge.asclipse.as3.element.AS3Import;
import jp.sourceforge.asclipse.as3.element.AS3Interface;
import jp.sourceforge.asclipse.as3.element.AS3Property;
import jp.sourceforge.asclipse.as3.element.AS3Variable;
import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.AIRResources;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ActionScriptLabelProvider extends LabelProvider {

	@Override
	public String getText(Object element) {
		if (element instanceof AS3Element) {
			return ((AS3Element) element).getOutlineTitle();
		}
		return super.getText(element);
	}

	public static Image getFunctionImage(AS3Function as3Function) {
		if (as3Function.isPrivate()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.METHOD_PRIVATE);

		} else if (as3Function.isPublic()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.METHOD_PUBLIC);

		} else if (as3Function.isProtected()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.METHOD_PROTECTED);

		} else {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.METHOD_DEFAULT);
		}
	}

	public static Image getPropertyImage(AS3Property as3Property) {
		if (as3Property.isPrivate()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.PROPERTY_PRIVATE);

		} else if (as3Property.isPublic()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.PROPERTY_PUBLIC);

		} else if (as3Property.isProtected()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.PROPERTY_PROTECTED);

		} else {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.PROPERTY_DEFAULT);
		}
	}

	private Image getInterfaceImage(AS3Interface as3Interface) {
		if (as3Interface.isPrivate()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.INTERFACE_PRIVATE);

		} else if (as3Interface.isPublic()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.INTERFACE_PUBLIC);

		} else if (as3Interface.isProtected()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.INTERFACE_PROTECTED);

		} else {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.INTERFACE_DEFALUT);
		}
	}

	private Image getClassImage(AS3Class as3Class) {
		if (as3Class.isPrivate()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CLASS_PRIVATE);

		} else if (as3Class.isPublic()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CLASS_PUBLIC);

		} else if (as3Class.isProtected()) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CLASS_PROTECTED);

		} else {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CLASS_DEFALUT);
		}
	}

	@Override
	public Image getImage(Object element) {
		if (element instanceof AS3Element) {

			AS3Element as3Element = (AS3Element) element;
			if (as3Element instanceof AS3Interface) {
				return getInterfaceImage((AS3Interface) as3Element);

			} else if (as3Element instanceof AS3Function) {
				return getFunctionImage((AS3Function) as3Element);

			} else if (as3Element instanceof AS3Import) {
				return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.IMPORT);

			} else if (as3Element instanceof AS3Class) {
				return getClassImage((AS3Class) as3Element);

			} else if (as3Element instanceof AS3ConstProperty) {
				AS3Element parent = as3Element.getParent();
				if (parent instanceof AS3ConstProperty) {
					return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONST);
				}

			} else if (as3Element instanceof AS3Variable) {
				AS3Element parent = as3Element.getParent();
				if (parent instanceof AS3Property) {
					return getPropertyImage((AS3Property) parent);
				}

			} else {
				String labelString = as3Element.getOutlineTitle();
				if (labelString.equals("Import declarations")) {
					return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.IMPORTS);
				}

				System.out.println("unnone:" + as3Element.getOutlineTitle());
			}
		}
		return super.getImage(element);
	}
}
