package net.sf.amateras.air.as.outline;

import jp.sourceforge.asclipse.as3.element.AS3Element;
import net.sf.amateras.air.as.ActionScriptEditor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ActionScriptOutlinePage extends ContentOutlinePage {

	protected Object fInput;
	protected IDocumentProvider fDocumentProvider;
	protected ActionScriptEditor fTextEditor;
	protected ActionScriptContentProvider actionScriptContentProvider;

	protected AS3Element fAs3Element;

	public ActionScriptOutlinePage(IDocumentProvider provider, ActionScriptEditor editor, AS3Element as3Element) {
		super();
		fAs3Element = as3Element;
		fDocumentProvider = provider;
		fTextEditor = editor;
		actionScriptContentProvider = new ActionScriptContentProvider(provider);
	}

	public void setAS3Element(AS3Element as3Element) {
		this.fAs3Element = as3Element;
		actionScriptContentProvider.setAS3Element(fAs3Element);
	}

	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);
		TreeViewer viewer = getTreeViewer();
		viewer.setContentProvider(actionScriptContentProvider);
		viewer.setLabelProvider(new ActionScriptLabelProvider());
		viewer.addSelectionChangedListener(this);

		if (fAs3Element != null) {
			viewer.setInput(fAs3Element);
		}
	}

	//	public ActionScriptContentProvider getAS3ContentProvider(IDocument document) {
	//		AS3Element element = actionScriptContentProvider.getAS3Element();
	//		if (element == null) {
	//			actionScriptContentProvider.parse(document);
	//		}
	//		return actionScriptContentProvider;
	//	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		super.selectionChanged(event);
		ISelection selection = event.getSelection();

		if (selection.isEmpty()) {
			fTextEditor.resetHighlightRange();
		} else {
			try {
				AS3Element segment = (AS3Element) ((IStructuredSelection) selection).getFirstElement();
				IDocument document = fDocumentProvider.getDocument(fInput);
				int line = segment.getStartLine() == -1 ? 0 : segment.getStartLine() - 1;
				int start = document.getLineOffset(line);
				int length = 1;
				try {
					fTextEditor.setHighlightRange(start, length, true);
				} catch (IllegalArgumentException x) {
					fTextEditor.resetHighlightRange();
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * Sets the input of the outline page
	 * 
	 * @param input the input of this outline page
	 */
	public void setInput(Object input) {
		fInput = input;
		update();
	}

	/**
	 * Updates the outline page.
	 */
	public void update() {
		TreeViewer viewer = getTreeViewer();
		if (viewer != null) {
			Control control = viewer.getControl();
			if (control != null && !control.isDisposed()) {
				control.setRedraw(false);
				viewer.setInput(fAs3Element);
				//viewer.expandAll();
				control.setRedraw(true);
			}
		}
	}
}
