package net.sf.amateras.air.as.syntax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class PreviousWord {
	public static final int TYPE_ALL = 1;
	public static final int TYPE_CLASS = 2;
	public static final int TYPE_CLASS_NEW = 3;
	public static final int TYPE_CLASS_METHOD = 4;
	public static final int TYPE_CLASS_ARG = 5;
	public static final int TYPE_IMPORT = 6;
	public static final int TYPE_METATAG = 7;

	public static final Pattern PATTERN_IMPORT = Pattern.compile(".*import[ ](.*)");
	public static final Pattern PATTERN_METHOD = Pattern.compile("(.*)\\.(.*)");
	public static final Pattern PATTERN_NEW = Pattern.compile(".*new[ ](.*)");
	public static final Pattern[] PATTERN_CLASSES = { Pattern.compile(".*as[ ](.*)"),
			Pattern.compile(".*extends[ ](.*)"), Pattern.compile(".*instanceof[ ](.*)") };
	public static final Pattern PATTERN_SPACE = Pattern.compile("/*[ |\t](.*)$");

	private String previousWord;
	private String className;
	private int type;

	public PreviousWord(IDocument document, int documentOffset) {
		StringBuilder buf = new StringBuilder();
		while (true) {
			try {
				char c = document.getChar(--documentOffset);

				if (c == ';' || c == '}' || c == '{' || c == '(' || c == ']' || c == '=') {
					break;
				} else if (c == ':') {
					type = TYPE_CLASS;
					previousWord = buf.reverse().toString();
					return;
				} else if (c != '\n') {
					buf.append(c);
				}

			} catch (BadLocationException e) {
				// nothing todo.
				break;
			}

		}
		String line = checkFormat(buf.reverse().toString());

		Matcher importMatcher = PATTERN_IMPORT.matcher(line);
		if (importMatcher.find()) {
			type = TYPE_IMPORT;
			previousWord = importMatcher.group(1);
			return;
		}
		Matcher newMatcher = PATTERN_NEW.matcher(line);
		if (newMatcher.find()) {
			type = TYPE_CLASS_NEW;
			previousWord = newMatcher.group(1);
			return;
		}
		Matcher methodMatcher = PATTERN_METHOD.matcher(line);
		if (methodMatcher.find()) {
			type = TYPE_CLASS_METHOD;
			className = methodMatcher.group(1);
			previousWord = methodMatcher.group(2);
			return;
		}

		for (Pattern classPattern : PATTERN_CLASSES) {
			Matcher matcher = classPattern.matcher(line);
			if (matcher.find()) {
				type = TYPE_CLASS;
				previousWord = matcher.group(1);
				return;
			}
		}

		// nothing match.
		line = line.trim();
		Matcher spaceMatcher = PATTERN_SPACE.matcher(line);
		if (spaceMatcher.find()) {
			line = spaceMatcher.group(1);
		}
		type = TYPE_ALL;
		previousWord = line;
	}

	private String checkFormat(String value) {
		char[] chars = value.toCharArray();
		int i = 0;
		for (i = 0; i < chars.length; i++) {
			if (chars[i] == ' ' || chars[i] == '\t') {
				continue;
			}
			break;
		}
		return value.substring(i);
	}

	public String getPreviousWord() {
		return previousWord;
	}

	public int getType() {
		return type;
	}

	public String getClassName() {
		return className;
	}
}
