package net.sf.amateras.air.as.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.MxmlAsMap;
import net.sf.amateras.air.as.ActionScriptEditor;
import net.sf.amateras.air.as.syntax.analyze.AS3Analizer;
import net.sf.amateras.air.as.syntax.analyze.FlexAnalizer;
import net.sf.amateras.air.as.syntax.analyze.MXMLAnalizer;
import net.sf.amateras.air.as.syntax.analyze.ProjectAnalizer;
import net.sf.amateras.air.as.syntax.analyze.ReservedWordsAnalizer;
import net.sf.amateras.air.as.syntax.analyze.TemplateAnalizer;
import net.sf.amateras.air.as.syntax.analyze.TopLevelAnalizer;
import net.sf.amateras.air.util.AIRResources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;

public class SyntaxReader {

	public static final String SYNTAX_FILE_DIRECTORY = "/syntax/";
	private static SyntaxReader myObject = new SyntaxReader();

	private SyntaxReader() {
		//TODO: change helper.
		//helper = new SampleConstantAssistHelper();
	}

	public static SyntaxReader getInstance() {
		return myObject;
	}

	/**
	 * ContentAssist result.
	 * 
	 * @param viewer
	 * @param documentOffset
	 * @return
	 */
	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset,
			ActionScriptEditor editor) {
		PreviousWord previousWord = new PreviousWord(viewer.getDocument(), documentOffset);
		List<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();

		// add "ReservedWords"
		if (previousWord.getType() == PreviousWord.TYPE_ALL) {
			ReservedWordsAnalizer re = new ReservedWordsAnalizer();
			re.addSyntaxClass(documentOffset, previousWord, proposals);
		}

		//TopLevel
		if (previousWord.getType() == PreviousWord.TYPE_ALL) {
			TopLevelAnalizer topLevelAnalizer = new TopLevelAnalizer();
			topLevelAnalizer.addSyntaxClass(documentOffset, previousWord, proposals);
		}

		IFile file = ((IFileEditorInput) editor.getEditorInput()).getFile();
		IProject project = file.getProject();

		// ProjectAnalizer
		if (AIRPlugin.getDefault().getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED)) {
			ProjectAnalizer projectAnalizer = new ProjectAnalizer();
			projectAnalizer.addSyntaxClass(documentOffset, previousWord, proposals, project);
		}

		//Flex
		if (AIRPlugin.getDefault().getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED)) {
			FlexAnalizer flexAnalizer = new FlexAnalizer();
			flexAnalizer.addSyntaxClass(documentOffset, previousWord, proposals, project);
		}

		//Template
		if (previousWord.getType() == PreviousWord.TYPE_ALL) {
			TemplateAnalizer templateAnalizer = new TemplateAnalizer();
			templateAnalizer.addSyntaxClass(documentOffset, previousWord, proposals, viewer);
		}

		List<ICompletionProposal> proposals2 = new ArrayList<ICompletionProposal>();
		// AS3Element
		if (AIRPlugin.getDefault().getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED)) {
			AS3Analizer as3Analizer = new AS3Analizer();
			as3Analizer.addSyntaxClass(documentOffset, previousWord, proposals2, editor.getAS3ChildElements());
		}

		// Mxml Analizer
		if (AIRPlugin.getDefault().getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED)) {
			if (file.getFileExtension().equalsIgnoreCase("as")) {
				IFile mxmlFile = MxmlAsMap.getInstance().getMxmlFile(file);
				if (mxmlFile != null) {
					MXMLAnalizer mxmlAnalizer = new MXMLAnalizer();
					try {
						mxmlAnalizer.addSyntaxClass(documentOffset, previousWord, proposals2, mxmlFile);
					} catch (CoreException e) {
						AIRPlugin.logException(e);
					}
				}
			}
		}

		Collections.sort(proposals2, new ASProposalComparator());
		Collections.sort(proposals, new ASProposalComparator());

		proposals2.addAll(proposals);

		return proposals2.toArray(new ICompletionProposal[proposals2.size()]);
	}

	public class ASProposalComparator implements Comparator<ICompletionProposal> {
		public int compare(ICompletionProposal p1, ICompletionProposal p2) {
			return p1.getDisplayString().toLowerCase().compareTo(p2.getDisplayString().toLowerCase());
		}
	}

	/**
	 * get type image.
	 * @param type TYPE_CLASS|TYPE_PROPERTY|TYPE_METHOD
	 * @return
	 */
	public static Image getTypeImage(int type) {
		if (type == ISyntaxClass.TYPE_CLASS) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CLASS_PUBLIC);
		} else if (type == ISyntaxClass.TYPE_PROPERTY) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.PROPERTY_PUBLIC);
		} else if (type == ISyntaxClass.TYPE_FUNCTION) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.METHOD_PUBLIC);
		} else if (type == ISyntaxClass.TYPE_INTERFACE) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.INTERFACE_PUBLIC);
		} else if (type == ISyntaxClass.TYPE_CONSTANT) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_RESERVED_WORD);
		} else if (type == ISyntaxClass.TYPE_RESERVED_WORD) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.CONTENTS_ASSIST_RESERVED_WORD);
		} else if (type == ISyntaxClass.TYPE_PACKAGE) {
			return AIRPlugin.getDefault().getImageRegistry().get(AIRResources.PACKAGE);
		} else {
			return null;
		}
	}

}
