package net.sf.amateras.air.as.syntax.analyze;

import java.util.List;

import jp.sourceforge.asclipse.as3.element.AS3Element;
import jp.sourceforge.asclipse.as3.element.AS3Function;
import jp.sourceforge.asclipse.as3.element.AS3Property;
import jp.sourceforge.asclipse.as3.element.AS3Variable;
import net.sf.amateras.air.as.outline.ActionScriptLabelProvider;
import net.sf.amateras.air.as.syntax.ISyntaxClass;
import net.sf.amateras.air.as.syntax.PreviousWord;
import net.sf.amateras.air.as.syntax.proposal.DefaultCompletionProposal;

import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class AS3Analizer {

	private int documentOffset;
	private PreviousWord previousWord;
	private List<ICompletionProposal> completionProposals;

	public void addSyntaxClass(int documentOffset, PreviousWord previousWord,
			List<ICompletionProposal> completionProposals, List<AS3Element> as3Elements) {

		if (as3Elements == null) {
			return;
		}
		if (previousWord.getType() != PreviousWord.TYPE_CLASS && previousWord.getType() != PreviousWord.TYPE_ALL
				&& previousWord.getType() != PreviousWord.TYPE_CLASS_METHOD) {
			return;
		}
		if (previousWord.getType() == PreviousWord.TYPE_CLASS_METHOD && !(previousWord.getClassName().equals("this"))) {
			return;
		}

		this.documentOffset = documentOffset;
		this.previousWord = previousWord;
		this.completionProposals = completionProposals;

		add(as3Elements);

	}

	private void add(List<AS3Element> as3Elements) {
		for (Object as3Element : as3Elements) {
			if (as3Element instanceof AS3Function) {
				addFunctionInfo((AS3Function) as3Element);
			} else if (as3Element instanceof AS3Variable) {
				addVariableInfo((AS3Variable) as3Element);
			}
		}
	}

	private void addFunctionInfo(AS3Function as3Function) {
		String name = as3Function.getIdentifier().toLowerCase();
		if (name.startsWith(previousWord.getPreviousWord().toLowerCase())) {
			DefaultCompletionProposal proposal = createProposal(ISyntaxClass.TYPE_FUNCTION, as3Function.getIdentifier()
					+ "()", as3Function.getOutlineTitle());
			proposal.setAdditionalProposalInfo(as3Function.getOutlineTitle());
			proposal.setDisplayString(as3Function.getOutlineTitle());
			proposal.setImage(ActionScriptLabelProvider.getFunctionImage(as3Function));
			proposal.setCursorPosition(proposal.getCursorPosition() - 1);
			completionProposals.add(proposal);
		}
	}

	private void addVariableInfo(AS3Variable as3Variable) {
		String name = as3Variable.getIdentifier().toLowerCase();
		if (name.startsWith(previousWord.getPreviousWord().toLowerCase())) {
			DefaultCompletionProposal proposal = createProposal(ISyntaxClass.TYPE_PROPERTY,
					as3Variable.getIdentifier(), as3Variable.getOutlineTitle());
			proposal.setAdditionalProposalInfo(as3Variable.getOutlineTitle());
			AS3Element parent = as3Variable.getParent();
			if (parent instanceof AS3Property) {
				proposal.setImage(ActionScriptLabelProvider.getPropertyImage((AS3Property) parent));
			}
			completionProposals.add(proposal);
		}
	}

	private DefaultCompletionProposal createProposal(int type, String replaceString, String id) {
		DefaultCompletionProposal proposal = new DefaultCompletionProposal(type, replaceString);
		proposal.setReplacementLength(previousWord.getPreviousWord().length());
		proposal.setReplacementOffset(documentOffset - previousWord.getPreviousWord().length());
		proposal.setCursorPosition(replaceString.length());
		proposal.setDisplayString(replaceString);
		proposal.setAdditionalProposalInfo(replaceString);

		return proposal;
	}

}
