package net.sf.amateras.air.as.syntax.analyze;

import java.util.List;
import java.util.Map;

import net.sf.amateras.air.ComponentImageRegistry;
import net.sf.amateras.air.as.syntax.ISyntaxClass;
import net.sf.amateras.air.as.syntax.PreviousWord;
import net.sf.amateras.air.as.syntax.proposal.DefaultCompletionProposal;
import net.sf.amateras.air.mxml.MXMLLoader;
import net.sf.amateras.air.mxml.descriptor.IEditorValueDescriptor;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.mxml.models.ModelProperty;
import net.sf.amateras.air.mxml.models.RootModel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class MXMLAnalizer {

	private int documentOffset;
	private PreviousWord previousWord;
	private List<ICompletionProposal> completionProposals;
	private String mxmlFileName;

	public void addSyntaxClass(int documentOffset, PreviousWord previousWord,
			List<ICompletionProposal> completionProposals, IFile mxmlFile) throws CoreException {

		if (previousWord.getType() != PreviousWord.TYPE_CLASS
				&& previousWord.getType() != PreviousWord.TYPE_CLASS_METHOD
				&& previousWord.getType() != PreviousWord.TYPE_ALL) {
			return;
		}

		this.documentOffset = documentOffset;
		this.previousWord = previousWord;
		this.completionProposals = completionProposals;
		this.mxmlFileName = mxmlFile.getName();

		RootModel root = new RootModel();
		MXMLLoader.loadMXML(mxmlFile.getContents(), root);
		addClass(root);

	}

	private void addClass(IComponentModel model) {

		String id = model.getAttributeToString("id");
		if (id != null && id.length() != 0) {
			if (previousWord.getType() == PreviousWord.TYPE_CLASS || previousWord.getType() == PreviousWord.TYPE_ALL) {
				addClassInfo(id, model);

			} else if (previousWord.getType() == PreviousWord.TYPE_CLASS_METHOD
					&& previousWord.getClassName().equals("this")) {
				addClassInfo(id, model);

			} else if (previousWord.getType() == PreviousWord.TYPE_CLASS_METHOD) {
				addMethodInfo(id, model);
			}
		}
		if (model instanceof IContainerModel) {
			IContainerModel container = (IContainerModel) model;
			for (IComponentModel subModel : container.getChildren()) {
				addClass(subModel);
			}
		}
	}

	private void addClassInfo(String id, IComponentModel model) {
		if (id.toLowerCase().startsWith(previousWord.getPreviousWord().toLowerCase())) {
			DefaultCompletionProposal proposal = createProposal(ISyntaxClass.TYPE_CLASS, id, id);
			proposal.setImage(ComponentImageRegistry.getImage(model));
			proposal.setAdditionalProposalInfo(model.toString());
			completionProposals.add(proposal);
		}
	}

	private void addMethodInfo(String id, IComponentModel model) {
		if (previousWord.getClassName().equals(id) || previousWord.getClassName().equals("this." + id)) {
			Map<Object, ModelProperty> modelProperties = model.getModelProperties();
			for (Object key : modelProperties.keySet()) {
				ModelProperty modelProperty = modelProperties.get(key);
				if (modelProperty.getCategory().equals(IModel.CATEGORY_STYLE)) {
					String propertyKey = key.toString().substring(1);
					String valuePrefix = "setStyle(\"" + propertyKey + "\", ";
					String value = valuePrefix.concat("\"\")");
					if (valuePrefix.startsWith(previousWord.getPreviousWord())) {
						DefaultCompletionProposal proposal = createProposal(ISyntaxClass.TYPE_PROPERTY, value, id);
						proposal.setAdditionalProposalInfo(getStyleAdditionalInfo(modelProperty, valuePrefix));
						proposal.setCursorPosition(proposal.getCursorPosition() - 2);
						proposal.setDisplayString(value + " - " + id + " - " + mxmlFileName);
						completionProposals.add(proposal);
					}
				} else {
					if (key.toString().startsWith("_" + previousWord.getPreviousWord())) {
						String propertyName = modelProperty.getPropertyName();
						DefaultCompletionProposal proposal = createProposal(ISyntaxClass.TYPE_PROPERTY, propertyName,
								id);
						proposal.setDisplayString(propertyName + " - " + mxmlFileName + "." + id);
						proposal.setAdditionalProposalInfo(propertyName + " - " + id + " - " + mxmlFileName);
						proposal.setDisplayString(propertyName + " - " + id + " - " + mxmlFileName);
						completionProposals.add(proposal);
					}
				}
			}
		}
	}

	private DefaultCompletionProposal createProposal(int type, String replaceString, String id) {
		DefaultCompletionProposal proposal = new DefaultCompletionProposal(type, replaceString);
		proposal.setReplacementLength(previousWord.getPreviousWord().length());
		proposal.setReplacementOffset(documentOffset - previousWord.getPreviousWord().length());
		proposal.setCursorPosition(replaceString.length());
		proposal.setDisplayString(replaceString + " - " + mxmlFileName);
		proposal.setAdditionalProposalInfo(replaceString);

		return proposal;
	}

	private String getStyleAdditionalInfo(ModelProperty modelProperty, String valuePrefix) {
		StringBuilder sb = new StringBuilder();
		sb.append(valuePrefix);
		if (modelProperty.getDescriptor() instanceof IEditorValueDescriptor<?>) {

			IEditorValueDescriptor<?> descriptor = (IEditorValueDescriptor<?>) modelProperty.getDescriptor();

			Object defaultValue = descriptor.getDefaultValue();
			String text = modelProperty.getDescriptor().getLabelProvider().getText(defaultValue);
			sb.append("\"").append(text).append("\")");
		} else {
			sb.append("\"\")");
		}
		return sb.toString();
	}
}
