package net.sf.amateras.air.as.syntax.analyze;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.as.syntax.ISyntaxClass;
import net.sf.amateras.air.as.syntax.PreviousWord;
import net.sf.amateras.air.as.syntax.SyntaxReader;
import net.sf.amateras.air.as.syntax.proposal.DefaultCompletionProposal;

import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ReservedWordsAnalizer {
	private static String[] reservedWords;

	public void addSyntaxClass(int documentOffset, PreviousWord previousWord, List<ICompletionProposal> result) {
		if (previousWord.getPreviousWord().length() <= 0) {
			return;
		}
		if (previousWord.getType() != PreviousWord.TYPE_ALL) {
			return;
		}

		String[] words = getReservedWords();

		for (int i = 0; i < words.length; i++) {
			if (words[i].toLowerCase().startsWith(previousWord.getPreviousWord().toLowerCase())) {
				DefaultCompletionProposal proposal = new DefaultCompletionProposal(ISyntaxClass.TYPE_RESERVED_WORD,
						words[i]);

				proposal.setReplacementOffset(documentOffset - previousWord.getPreviousWord().length());
				proposal.setReplacementLength(previousWord.getPreviousWord().length());
				proposal.setCursorPosition(words[i].length());
				proposal.setDisplayString(words[i]);
				proposal.setAdditionalProposalInfo(words[i] + " is reserved words");
				proposal.setContextInformation(new ContextInformation(words[i], words[i] + " is reserved words"));
				result.add(proposal);
			}
		}
	}

	/**
	 * get reserved words list from file.
	 * file is syntax/ReservedWord.txt
	 * @return
	 */
	public String[] getReservedWords() {
		if (reservedWords == null) {
			reservedWords = readStreamToStringArray("ReservedWord");
		}
		return reservedWords;
	}

	/**
	 * read file, return StringArray.
	 * @param filePath
	 * @return
	 */
	private String[] readStreamToStringArray(String filePath) {
		BufferedReader bReader = null;
		InputStream input = null;

		try {
			input = getClass().getResourceAsStream(SyntaxReader.SYNTAX_FILE_DIRECTORY + filePath);
			bReader = new BufferedReader(new InputStreamReader(input));
			String line;
			ArrayList<String> list = new ArrayList<String>();

			while ((line = bReader.readLine()) != null) {
				if (line.length() == 0) {
					continue;
				}
				list.add(line);
			}
			return list.toArray(new String[list.size()]);

		} catch (IOException e) {
			e.printStackTrace();
			return null;
		} finally {
			try {
				if (bReader != null) {
					bReader.close();
				}
				if (input != null) {
					input.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
