package net.sf.amateras.air.debug;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * 
 * @author hideko ogawa
 *
 */
public class AirToggleBreakpointsTarget implements IToggleBreakpointsTargetExtension {

	public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
		return canToggleLineBreakpoints(part, selection);
	}

	public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
		return selection instanceof ITextSelection;
	}

	public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
		return selection instanceof ITextSelection;
	}

	public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
		return false;
	}

	public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) {
		toggleLineBreakpoints(part, selection);
	}

	public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) {
		Job job = new Job("Toggle Line Breakpoint (air)") {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				ITextEditor editor = getTextEditor(part);
				if ((editor == null) || !(selection instanceof ITextSelection)) {
					return Status.OK_STATUS;
				}

				int lineNumber = ((TextSelection) selection).getStartLine() + 1;
				IResource resource = getResource(editor);

				try {
					IBreakpoint breakpoint = lineBreakpointExists(resource, lineNumber);

					if (breakpoint != null) {
						removeBreakpoint(breakpoint, true);
					} else {
						createLineBreakpoint(resource, lineNumber);
					}

					return Status.OK_STATUS;
				} catch (CoreException e) {
					return e.getStatus();
				}
			}
		};

		job.setSystem(true);
		job.schedule();
	}

	private static IBreakpoint lineBreakpointExists(IResource resource, int lineNumber) throws CoreException {
		String modelId = AirLineBreakPoint.DEBUG_MODEL_IDENTIFIER;

		IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
		IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);

		for (int i = 0; i < breakpoints.length; i++) {
			AirLineBreakPoint breakpoint = (AirLineBreakPoint) breakpoints[i];
			IMarker marker = breakpoint.getMarker();
			if (isValidMarker(marker)) {
				if (breakpoint.getLineNumber() == lineNumber && resource.equals(marker.getResource())) {
					return breakpoint;
				}
			}
		}

		return null;
	}

	private static boolean isValidMarker(IMarker marker) {
		return marker != null && marker.exists();
	}

	public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
	}

	public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) {
	}

	private IResource getResource(ITextEditor editor) {
		IResource resource = (IResource) editor.getEditorInput().getAdapter(IFile.class);

		if (resource == null) {
			resource = (IResource) editor.getEditorInput().getAdapter(IResource.class);
		}

		return resource;
	}

	private ITextEditor getTextEditor(IWorkbenchPart part) {
		if (part instanceof ITextEditor) {
			return (ITextEditor) part;
		}

		return (ITextEditor) part.getAdapter(ITextEditor.class);
	}

	private void createLineBreakpoint(IResource resource, int lineNumber) {
		try {
			new AirLineBreakPoint().addBreakPointManager(resource, lineNumber);
		} catch (CoreException e) {
			AIRPlugin.logException(e);
		}

	}

	private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
		DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
	}

}
