package net.sf.amateras.air.debug.event;

import java.util.List;

import net.sf.amateras.air.debug.matcher.StackframeMatchResult;

import org.eclipse.debug.core.DebugEvent;

public interface IAirEventListener {

	void waitingStartPlayer(String event);

	void waitingConnectPlayer(String event);

	void waitingContinue(String event);

	void waitingAddBreakpoint(String event);

	/**
	 * 
	 * @param event
	 * @param file
	 * @param lineNo
	 * @param debugEvent {@link DebugEvent#BREAKPOINT} etc...
	 */
	void suspended(String event, String file, int lineNo, int debugEvent);

	/**
	 * 
	 * @param event
	 */
	void resumed(String event, int debugEvent);

	/**
	 * when player terminated
	 */
	void playerTerminated();

	void resultOfStackFrames(List<StackframeMatchResult> results);

}
