package net.sf.amateras.air.debug.matcher;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.debug.AirDebugTarget;
import net.sf.amateras.air.debug.thread.AirValue;
import net.sf.amateras.air.debug.watch.AirWatchExpression;
import net.sf.amateras.air.debug.watch.ExpressionMatchResult;

import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpressionResult;

/**
 * english
 * 
 * @author hideko ogawa
 */
public class FdbConsoleTextMatcher {

	private static Pattern breakpointPattern = Pattern.compile(getResourceString("FdbConsoleTextMatcher.0")); //$NON-NLS-1$
	//private static Pattern breakpointPattern2 = Pattern.compile(getResourceString("FdbConsoleTextMatcher.1")); //$NON-NLS-1$

	private static Pattern stopPattern1 = Pattern.compile(getResourceString("FdbConsoleTextMatcher.1")); //$NON-NLS-1$
	private static Pattern stopPattern2 = Pattern.compile(getResourceString("FdbConsoleTextMatcher.2")); //$NON-NLS-1$
	private static Pattern stopPattern3 = Pattern.compile(getResourceString("FdbConsoleTextMatcher.3")); //$NON-NLS-1$

	private static Pattern expressionPattern = Pattern.compile(getResourceString("FdbConsoleTextMatcher.4")); //$NON-NLS-1$
	private static Pattern stackFramePattern = Pattern.compile(getResourceString("FdbConsoleTextMatcher.5")); //$NON-NLS-1$

	private FdbConsoleTextMatcher() {
	}

	private static String getResourceString(String key) {
		return AIRPlugin.getResourceString(key);
	}

	/**
	 * when can not execute player
	 * @param text
	 * @return
	 */
	public static boolean isPlayerTerminated(String text) {
		return text.indexOf(getResourceString("FdbConsoleTextMatcher.6")) >= 0 //$NON-NLS-1$
				|| text.indexOf(getResourceString("FdbConsoleTextMatcher.7")) >= 0 ? true : false; //$NON-NLS-1$
	}

	public static boolean isWaitingStartPlayer(String text) {
		return text.indexOf(getResourceString("FdbConsoleTextMatcher.8")) >= 0 ? true : false; //$NON-NLS-1$
	}

	public static boolean isWaitingConnectPlayer(String text) {
		return text.indexOf(getResourceString("FdbConsoleTextMatcher.9")) >= 0 ? true : false; //$NON-NLS-1$
	}

	public static boolean isWaitingContinue(String text) {
		return text.indexOf(getResourceString("FdbConsoleTextMatcher.10")) >= 0 //$NON-NLS-1$
				|| text.indexOf(getResourceString("FdbConsoleTextMatcher.11")) >= 0 ? true : false; //$NON-NLS-1$
	}

	public static boolean isWaitingAddBreakpoint(String text) {
		return text.indexOf(getResourceString("FdbConsoleTextMatcher.12")) >= 0 ? true : false; //$NON-NLS-1$
	}

	/**
	 * Breakpoint match
	 * @param text
	 * @return
	 */
	public static BreakpointMatchResult breakpointMatch(String text) {
		Matcher matcher = breakpointPattern.matcher(text);
		BreakpointMatchResult result = getResult(matcher);
		//		if (!result.isMatched) {
		//			matcher = breakpointPattern2.matcher(text);
		//			result = getResult(matcher);
		//		}
		return result;
	}

	/**
	 * step stop match
	 * @param text
	 * @return
	 */
	public static BreakpointMatchResult stepMatch(String text) {
		Matcher matcher = stopPattern1.matcher(text);
		BreakpointMatchResult result = new BreakpointMatchResult();
		if (matcher.find()) {
			if (matcher.groupCount() > 1) {
				result.isMatched = true;
				result.fileName = matcher.group(1);
				result.lineNo = Integer.parseInt(matcher.group(2));
				return result;
			}
		}
		matcher = stopPattern2.matcher(text);
		if (matcher.find()) {
			if (matcher.groupCount() > 1) {
				result.isMatched = true;
				result.fileName = matcher.group(1);
				result.lineNo = Integer.parseInt(matcher.group(2));
				return result;
			}
		}
		matcher = stopPattern3.matcher(text);
		if (matcher.find()) {
			if (matcher.groupCount() >= 1) {
				result.isMatched = true;
				result.lineNo = Integer.parseInt(matcher.group(1));
				return result;
			}
		}
		//		matcher = stopPattern.matcher(text);
		//		if (matcher.find()) {
		//			result.isMatched = true;
		//			result.lineNo = Integer.parseInt(matcher.group(1));
		//			return result;
		//		}
		result.isMatched = false;
		return result;
	}

	/**
	 * 
	 * @param text
	 * @return
	 */
	public static List<IWatchExpressionResult> expressionMatch(AirDebugTarget target, String text) {
		List<IWatchExpressionResult> values = new ArrayList<IWatchExpressionResult>();

		if (text != null && text.length() != 0) {
			IExpression[] expressions = target.getExpressionManager().getExpressions();
			String[] split = text.split(getResourceString("FdbConsoleTextMatcher.13")); //$NON-NLS-1$
			for (String s : split) {
				Matcher matcher = expressionPattern.matcher(s);
				if (matcher.find()) {
					String id = matcher.group(1);
					String expression = matcher.group(2);
					String value = matcher.group(3);
					for (IExpression e : expressions) {
						if (e.getExpressionText().endsWith(expression)) {
							if (e instanceof AirWatchExpression) {
								((AirWatchExpression) e).setId(id);
								ExpressionMatchResult result = new ExpressionMatchResult(new AirValue(target, value));
								result.setExpressionText(expression);
								((AirWatchExpression) e).setResult(result);
								values.add(result);
								break;
							}
						}
					}
				}
			}
		}
		return values;
	}

	/**
	 * 
	 * @param matcher
	 * @return
	 */
	private static BreakpointMatchResult getResult(Matcher matcher) {
		BreakpointMatchResult result = new BreakpointMatchResult();
		if (matcher.find()) {
			if (matcher.groupCount() >= 3) {
				result.isMatched = true;
				result.breakpointNo = Integer.parseInt(matcher.group(1));
				result.fileName = matcher.group(2);
				result.lineNo = Integer.parseInt(matcher.group(3));
				return result;
			}
		}
		result.isMatched = false;
		return result;
	}

	public static List<StackframeMatchResult> matchStackFramesPattern(String text) {
		List<StackframeMatchResult> lists = new ArrayList<StackframeMatchResult>();
		if (text == null || text.length() == 0) {
			return lists;
		}
		String[] texts = text.split(getResourceString("FdbConsoleTextMatcher.12")); //$NON-NLS-1$
		for (String value : texts) {
			Matcher matcher = stackFramePattern.matcher(value);
			if (matcher.find()) {
				StackframeMatchResult result = new StackframeMatchResult();
				result.id = matcher.group(1);
				result.objectString = matcher.group(2);
				result.methodString = matcher.group(3);
				result.sourceName = matcher.group(4);
				result.lineNo = Integer.parseInt(matcher.group(5));
				lists.add(result);
			}
		}
		return lists;
	}
}
