package net.sf.amateras.air.debug.sourcelocater;

import net.sf.amateras.air.debug.thread.AirStackFrame;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;

/**
 * SourceLookupParticipant　for AIR GEAR
 * 
 * @author ogawa hideko
 *
 */
public class AirSourceLookupParticipant extends AbstractSourceLookupParticipant {

	public String getSourceName(Object object) {
		if (object instanceof IFile) {
			return ((IFile) object).getName();

		} else if (object instanceof AirStackFrame) {
			String sourceName = ((AirStackFrame) object).getSourceName();
			return sourceName;

		} else if (object instanceof String) {
			return (String) object;
		}
		return null;
	}

}
