package net.sf.amateras.air.debug.thread;

import net.sf.amateras.air.debug.AirDebugElement;

import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class AirValue extends AirDebugElement implements IValue {

	private String value;

	public AirValue(IDebugTarget debugTarget, String value) {
		super(debugTarget);
		this.value = value;
	}

	public String getReferenceTypeName() {
		try {
			Integer.parseInt(value);
		} catch (NumberFormatException e) {
			return "text";
		}
		return "integer";
	}

	public String getValueString() {
		return value;
	}

	public boolean isAllocated() {
		return true;
	}

	public IVariable[] getVariables() {
		return new IVariable[0];
	}

	public boolean hasVariables() {
		if (value == null) {
			return false;
		} else {
			return value.length() > 1;
		}
	}

	//    @Override
	//    public boolean equals(Object obj) {
	//        return obj instanceof AirValue && ((AirValue) obj).value.equals(value);
	//    }

}
