package net.sf.amateras.air.expressions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

/**
 * Test whether Nature is corresponding.
 * 
 * @author ogawahideko
 *
 */
public class NaturePropertyTester extends PropertyTester {

	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if (receiver instanceof IResource) {
			IProject project = ((IResource) receiver).getProject();
			try {
				return project.hasNature(expectedValue.toString());
			} catch (CoreException e) {
				return false;
			}
		}
		return false;
	}

}
