package net.sf.amateras.air.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;

/**
 * ADT execute Lanch.
 * 
 * @author ogawahideko
 *
 */
@SuppressWarnings("restriction")
public class LaunchADTConfiguration extends LaunchConfigurationDelegate implements IDebugEventSetListener {

	public static final String ID = "net.sf.amateras.air.launchADTConfigurationType";
	public static final String KEY_PROJECT = "air.PROJECT";
	public static final String KEY_OPTIONS = "air.OPTIONS";

	public void handleDebugEvents(DebugEvent[] events) {
	}

	@Override
	protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
		String projectName = configuration.getAttribute(KEY_PROJECT, "");
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		if (project == null) {
			return null;
		}

		return new IProject[] { project };
	}

	public String getAdtPath() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String adtPath = store.getString(AIRPlugin.PREF_ADT_COMMAND);
		return adtPath;
	}

	public void launch(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
		launch(configuration, ILaunchManager.RUN_MODE, null, monitor);
	}

	@SuppressWarnings("unchecked")
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor)
			throws CoreException {

		String projectName = configuration.getAttribute(KEY_PROJECT, "");
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);

		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		if (project == null || !ProcessUtil.checkAirGearProject(project)) {
			return;
		}
		String adtPath = store.getString(AIRPlugin.PREF_ADT_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(adtPath);
		if (sdkPath == null) {
			return;
		}

		File adt = new File(sdkPath, adtPath);
		File currentDir = new File(project.getLocation().toString());

		try {
			List<String> options = configuration.getAttribute(KEY_OPTIONS, new ArrayList<String>());
			String[] args = options.toArray(new String[options.size()]);

			StringBuilder sb = new StringBuilder();
			sb.append("adt");
			for (String arg : args) {
				sb.append(" " + arg);
			}

			Process process = ProcessUtil.createProcess(adt, args, currentDir);

			MyLaunch myLaunch = new MyLaunch(configuration, ILaunchManager.RUN_MODE, null);

			IProcess proc = DebugPlugin.newProcess(myLaunch, process, sb.toString());
			myLaunch.setProcess(proc);
			DebugPlugin.getDefault().getLaunchManager().addLaunch(myLaunch);

			DebugUIPlugin.getDefault().getProcessConsoleManager().launchAdded(launch);

			process.waitFor();

			project.refreshLocal(IResource.DEPTH_INFINITE, null);

		} catch (Exception ex) {
			ex.printStackTrace();
		}

	}

	class MyLaunch extends Launch {
		private IProcess process;

		public MyLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
			super(launchConfiguration, mode, locator);

		}

		public void setProcess(IProcess process) {
			this.process = process;
		}

		@Override
		public IProcess[] getProcesses() {
			if (process == null) {
				return null;
			}
			return new IProcess[] { process };
		}
	}

	public static ILaunchConfigurationWorkingCopy getADTConfiguration(IProject project, String name) {
		try {
			ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
			ILaunchConfigurationType type = manager.getLaunchConfigurationType(LaunchADTConfiguration.ID);

			ILaunchConfigurationWorkingCopy workingCopy = null;
			//			String name = DebugPlugin.getDefault().getLaunchManager()
			//					.generateUniqueLaunchConfigurationNameFrom(
			//							ExternalToolsUIMessages.BuilderPropertyPage_New_Builder_7);
			workingCopy = type.newInstance(BuilderUtils.getBuilderFolder(project, true), name);
			workingCopy.doSave();
			return workingCopy;
		} catch (CoreException e) {
			e.printStackTrace();
			return null;
		}
	}

}
