package net.sf.amateras.air.mxml.action;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.editparts.command.CreateCommand;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;
import net.sf.amateras.air.mxml.models.DataGridModel;
import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;

/**
 * add GridDataColumn to GridData.
 * @author ogawahideko
 *
 */
public class AddGridDataColumnAction extends MXMLEditorAction {
	private DataGridModel selectedModel;

	public AddGridDataColumnAction(VisualMXMLEditor editor) {
		super(AIRPlugin.getResourceString("ADD_DATAGRIDCOLUMN"), editor);
		setImageDescriptor(AIRPlugin.getImageDescriptor("icons/table.gif"));
	}

	@Override
	public void run() {
		if (selectedModel == null) {
			return;
		} else {
			InputDialog input = new InputDialog(Display.getDefault().getActiveShell(), "", AIRPlugin
					.getResourceString("ENTRY_TITLE"), null, null);
			if (input.open() == InputDialog.CANCEL) {
				return;
			}
			String title = input.getValue();
			DataGridColumnModel model = new DataGridColumnModel(title);
			FlexRectangle rec = new FlexRectangle();
			rec.setStrWidth("100");
			rec.setStrHeight("");
			CreateCommand command = new CreateCommand(selectedModel, model, rec);
			getCommandStack().execute(command);
		}
	}

	public void setDataGridModel(DataGridModel selectedModel) {
		this.selectedModel = selectedModel;
	}

	@Override
	public void update(IStructuredSelection selection) {
		// Nothing todo.
	}

}
