package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * Descriptor for value of Double.
 * @author ogawahideko
 *
 */
public class DoublePropertyDescriptor extends TextPropertyDescriptor implements IEditorValueDescriptor<Double> {

	private Double defaultValue;

	public DoublePropertyDescriptor(Object id, String displayName, Double defaultValue) {
		super(id, displayName);
		setValidator(new DoubleValidator());
		this.defaultValue = defaultValue;
		setLabelProvider(new MyLabelDecorator());
	}

	class DoubleValidator implements ICellEditorValidator {
		public String isValid(Object value) {
			if (value != null && value.toString().length() > 0) {
				char[] charArray = value.toString().toCharArray();
				for (int i = 0; i < charArray.length; i++) {
					if (!Character.isDigit(charArray[i])) {
						if (i == 0 && charArray[i] == '-') {
							continue;
						} else if (charArray[i] != '.') {
							return "The input value is not a numerical value. ";
						}
					}
				}
				return null;
			}
			return null;
		}
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new DoubleCellEditor(parent);
		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
		return editor;
	}

	class DoubleCellEditor extends TextCellEditor {
		DoubleCellEditor(Composite parent) {
			super(parent);
		}

		@Override
		protected void doSetValue(Object value) {
			if (value == null || value == AbstractModel.NULL_PROPERTY) {
				text.setText(AbstractModel.NULL_PROPERTY);
			} else {
				Assert.isTrue(text != null && (value instanceof Double));
				text.setText(String.valueOf(value));
			}

		}

		@Override
		protected Object doGetValue() {
			String value = text.getText();
			if (value == null || value.length() == 0) {
				return AbstractModel.NULL_PROPERTY;
			} else {
				return Double.valueOf(value);
			}
		}
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Double getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public Double getEditorValue(Double value) {
		if (value != null) {
			return value;
		} else {
			return defaultValue;
		}
	}

	class MyLabelDecorator extends PropertyLabelDecoratorUtil {
		@Override
		protected String getDefaultValue() {
			if (defaultValue == null) {
				return AbstractModel.NULL_PROPERTY;
			} else {
				return defaultValue.toString();
			}
		}
	}

}
