package net.sf.amateras.air.mxml.descriptor;

import net.sf.amateras.air.mxml.models.AbstractModel;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * PropertyDescriptor selected from list(String[]).
 * @author ogawahideko
 *
 */
public class StringListPropertyDescriptor extends TextPropertyDescriptor implements IEditorValueDescriptor<String> {

	private String[] list;
	private String defaultValue;

	public StringListPropertyDescriptor(Object id, String displayName, String[] list) {
		super(id, displayName);
		this.list = list;
		if (list.length > 0) {
			defaultValue = new String(list[0]);
		}
		setLabelProvider(new PropertyLabelDecoratorUtil(defaultValue));
	}

	public StringListPropertyDescriptor(Object id, String displayName, String[] list, String defaultValue) {
		super(id, displayName);
		this.list = list;
		this.defaultValue = new String(defaultValue);
		setLabelProvider(new PropertyLabelDecoratorUtil(defaultValue));
	}

	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor editor = new ComboBoxCellEditor(parent, list, SWT.NONE) {
			@Override
			public void doSetValue(Object value) {
				if (value == null || value == AbstractModel.NULL_PROPERTY) {
					super.doSetValue(new Integer(-1));
				} else {
					for (int i = 0; i < list.length; i++) {
						if (list[i].equalsIgnoreCase(value.toString())) {
							super.doSetValue(new Integer(i));
							return;
						}
					}
					// no hit.
					((CCombo) super.getControl()).setText(value.toString());
				}
			}

			@Override
			public Object doGetValue() {
				return ((CCombo) super.getControl()).getText();
				//				int selection = ((Integer) super.doGetValue()).intValue();
				//				if (selection == -1) {
				//					return AbstractModel.NULL_PROPERTY;
				//				} else {
				//					return list[selection];
				//				}
			}
		};

		if (getValidator() != null) {
			editor.setValidator(getValidator());
		}

		return editor;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getDefaultValue() {
		return defaultValue;
	}

	/**
	 * implement {@link IEditorValueDescriptor}
	 */
	public String getEditorValue(String value) {
		if (value != null && value.length() != 0) {
			return value;
		} else if (defaultValue != null) {
			return defaultValue;
		} else {
			return AbstractModel.NULL_PROPERTY;
		}
	}

}
