package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.RootFigure;
import net.sf.amateras.air.mxml.models.ApplicationModel;
import net.sf.amateras.air.mxml.models.WindowedApplicationModel;

import org.eclipse.gef.EditPolicy;

/**
 * The editpart for the {@link ApplicationModel} or {@link WindowedApplicationModel}
 * 
 * @author ogawahideko
 */
public class ApplicationEditPart extends WindowEditPart {

	@Override
	protected void updateFigure(RootFigure figure) {
		ApplicationModel model = (ApplicationModel) getModel();
		setDefaultSize(figure);

		String direction = (String) model.getAttribute(ApplicationModel.LAYOUT);
		if (direction.equalsIgnoreCase("vertical")) {
			figure.setLayout(false);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());

		} else if (direction.equalsIgnoreCase("horizontal")) {
			figure.setLayout(false);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());

		} else {
			figure.setLayout(true);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
		}
	}

}
